/***************************************************************************
    file	         : kb_ora10iadvanced.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/



#ifndef		_WIN32
#include	"kb_ora10iadvanced.moc"
#else
#include	"kb_ora10iadvanced.h"
#endif

#include	<qcheckbox.h>
#include	<qlabel.h>
#include	<qspinbox.h>

#include	<qvbox.h>
#include	<qhbox.h>
#include	<qlineedit.h>
#include	<qpushbutton.h>
#include	<qtabwidget.h>
#include	<qtextedit.h>


#ifdef	__NOTYET

KBOra10iGrantsDlg::KBOra10iGrantsDlg
	(	bool		grantSelect,
		bool		grantInsert,
		bool		grantUpdate,
		bool		grantDelete,
		const QString	&grantTo,
		bool		mapExpressions
	)
	:
	QDialog		(),
	m_mapExpressions(mapExpressions)
{
	QVBox		*layMain    = new QVBox (this) ;
	layMain->setTracking () ;

	setCaption	(TR("Set grants")) ;

	m_cbGrantSelect	= new QCheckBox (TR("Grant select"), layMain) ;
	m_cbGrantInsert	= new QCheckBox (TR("Grant insert"), layMain) ;
	m_cbGrantUpdate	= new QCheckBox (TR("Grant update"), layMain) ;
	m_cbGrantDelete	= new QCheckBox (TR("Grant delete"), layMain) ;

	QHBox		*layTo		= new QHBox (layMain) ;
	new QLabel (TR("To"), layTo) ;
	m_leGrantTo	= new QLineEdit (layTo) ;

	QHBox		*layButt	= new QHBox (layMain) ;
	layButt->addFiller () ;
	QPushButton	*bOK		= new QPushButton (TR("OK"),     layButt) ;
	QPushButton	*bSkip		= new QPushButton (TR("Skip"),   layButt) ;
	QPushButton	*bCancel	= new QPushButton (TR("Cancel"), layButt) ;

	m_cbGrantSelect	->setChecked (grantSelect) ;
	m_cbGrantInsert	->setChecked (grantInsert) ;
	m_cbGrantUpdate	->setChecked (grantUpdate) ;
	m_cbGrantDelete	->setChecked (grantDelete) ;
	m_leGrantTo	->setText    (grantTo)	  ;

	connect	(bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(bSkip,   SIGNAL(clicked()), SLOT(clickSkip  ())) ;
	connect	(bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
}

void	KBOra10iGrantsDlg::clickOK ()
{
	if (
		!m_cbGrantSelect->isChecked() &&
		!m_cbGrantInsert->isChecked() &&
		!m_cbGrantUpdate->isChecked() &&
		!m_cbGrantDelete->isChecked()
	   )
	{
		KBError::EWarning
		(	TR("At least one grant must be given"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	if (m_leGrantTo->text().isEmpty())
	{
		KBError::EWarning
		(	TR("Please specify to whom to grant"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	done	(2) ;
}

void	KBOra10iGrantsDlg::clickSkip ()
{
	done	(1) ;
}

void	KBOra10iGrantsDlg::clickCancel ()
{
	done	(0) ;
}

QString	KBOra10iGrantsDlg::grantText ()
{
	QString	text	= "grant " ;
	cchar	*sep	= ""	   ;

	if (m_cbGrantSelect->isChecked())
	{	text	+= sep		;
		text	+= "select"	;
		sep	 = ", "		;
	}
	if (m_cbGrantInsert->isChecked())
	{	text	+= sep		;
		text	+= "insert"	;
		sep	 = ", "		;
	}
	if (m_cbGrantUpdate->isChecked())
	{	text	+= sep		;
		text	+= "update"	;
		sep	 = ", "		;
	}
	if (m_cbGrantDelete->isChecked())
	{	text	+= sep		;
		text	+= "delete"	;
		sep	 = ", "		;
	}

	text	+= m_mapExpressions ? " on \"%1\" to " : " on %1 to " ;
	text	+= m_leGrantTo->text() ;
	return	text ;
}

#endif

/*  ------------------------------------------------------------------  */

/*  KBOra10iAdvanced							*/
/*  KBOra10iAdvanced							*/
/*		: Constructor for Ora10i advanced options object	*/
/*  (returns)	: KBOra10iAdvanced	:				*/

KBOra10iAdvanced::KBOra10iAdvanced  ()
	:
	KBDBAdvanced ("ora10i")
{
	fprintf	(stderr, "KBOra10iAdvanced::KBOra10iAdvanced  ()\n") ;

	m_showRowID		= false	;
	m_showOra10iObjects	= false ;
	m_useTimeouts		= false ;
#ifdef	__NOTYET
	m_stmtTimeout		= -1	;
#endif
	m_lockTimeout		= -1	;
	m_connectStr		= ""	;

#ifdef	__NOTYET
	m_grants		= false	;
	m_grantSelect		= false	;
	m_grantInsert		= false	;
	m_grantUpdate		= false	;
	m_grantDelete		= false	;
	m_grantTo		= ""	;
	m_grantPopup		= false	;
#endif
}

/*  KBOra10iAdvanced							*/
/*  ~KBOra10iAdvanced							*/
/*		: Destructor for Ora10i advanced options object		*/
/*  (returns)	:		:					*/

KBOra10iAdvanced::~KBOra10iAdvanced ()
{
}

/*  KBOra10iAdvanced							*/
/*  load	: Load settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBOra10iAdvanced::load
	(	const QDomElement &driverElem
	)
{
	m_showRowID		= driverElem.attribute ("showrowid" 	   ).toUInt() ;
	m_showOra10iObjects	= driverElem.attribute ("showora10iobjects").toUInt() ;
	m_useTimeouts	  	= driverElem.attribute ("usetimeouts"      ).toUInt() ;
#ifdef	__NOTYET
	m_stmtTimeout 	  	= driverElem.attribute ("stmttimeout"	   ).toInt () ;
#endif
	m_lockTimeout 	  	= driverElem.attribute ("locktimeout"	   ).toInt () ;
	m_connectStr 	  	= driverElem.attribute ("connectstr"	   ) ;

#ifdef	__NOTYET
	m_grants	  	= driverElem.attribute ("grants"	   ).toUInt() ;
	m_grantSelect	  	= driverElem.attribute ("grantselect"      ).toUInt() ;
	m_grantInsert	  	= driverElem.attribute ("grantinsert"      ).toUInt() ;
	m_grantUpdate	  	= driverElem.attribute ("grantupdate"      ).toUInt() ;
	m_grantDelete	  	= driverElem.attribute ("grantdelete"      ).toUInt() ;
	m_grantTo	  	= driverElem.attribute ("grantto"	   ) ;
	m_grantPopup	  	= driverElem.attribute ("grantpopup"       ).toUInt() ;
#endif
}

/*  KBOra10iAdvanced							*/
/*  save	: Save settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBOra10iAdvanced::save
	(	QDomElement	&driverElem
	)
{
	driverElem.setAttribute ("showrowid", 		 m_showRowID		) ;
	driverElem.setAttribute ("showora10iobjects",	 m_showOra10iObjects	) ;
	driverElem.setAttribute ("usetimeouts",      	 m_useTimeouts		) ;
#ifdef	__NOTYET
	driverElem.setAttribute ("stmttimeout",     	 m_stmtTimeout		) ;
#endif
	driverElem.setAttribute ("locktimeout",     	 m_lockTimeout		) ;
	driverElem.setAttribute ("connectstr",     	 m_connectStr		) ;

#ifdef	__NOTYET
	driverElem.setAttribute ("grants",	    	 m_grants		) ;
	driverElem.setAttribute ("grantselect",     	 m_grantSelect		) ;
	driverElem.setAttribute ("grantinsert",     	 m_grantInsert		) ;
	driverElem.setAttribute ("grantupdate",     	 m_grantUpdate		) ;
	driverElem.setAttribute ("grantdelete",     	 m_grantDelete		) ;
	driverElem.setAttribute ("grantto",	    	 m_grantTo		) ;
	driverElem.setAttribute ("grantpopup",      	 m_grantPopup		) ;
#endif
}

/*  KBOra10iAdvanced							*/
/*  setupDialog	: Set up advanced options dialog			*/
/*  tabWidget	: QTabWidget *	: Tab widget to which to attach pages	*/
/*  (returns)	: void		:					*/

void	KBOra10iAdvanced::setupDialog
	(	QTabWidget	*tabWidget
	)
{
	fprintf	(stderr, "KBOra10iAdvanced::setupDialog  ()\n") ;

	QVBox		*layGeneral	= new QVBox (tabWidget) ;
#ifdef	__NOTYET
	QVBox		*layGrants	= new QVBox (tabWidget) ;
#endif

	tabWidget->addTab (layGeneral, "Oracle10i") ;
#ifdef	__NOTYET
	tabWidget->addTab (layGrants,  "Grants"    ) ;
#endif
	m_cbShowRowID		= new QCheckBox (TR("Show ROWID in table columns"),  	layGeneral) ;
	m_cbShowOra10iObjects	= new QCheckBox (TR("Show Oracle10i objects"),		layGeneral) ;
	m_cbUseTimeouts		= new QCheckBox (TR("Use statement timeouts"),		layGeneral) ;

	m_cbShowRowID	     ->setChecked (m_showRowID 		) ;
	m_cbShowOra10iObjects->setChecked (m_showOra10iObjects	) ;
	m_cbUseTimeouts	     ->setChecked (m_useTimeouts	) ;

	QHBox	*layTimeout	= new QHBox (layGeneral) ;
#ifdef	__NOTYET
	new QLabel (TR("Statement timeout"), layTimeout) ;
	m_spStmtTimeout	= new QSpinBox	(0, 0x7fffffff, 1, layTimeout) ;
	m_spStmtTimeout ->setValue      (m_stmtTimeout >= 0 ? m_stmtTimeout : 0) ;
	m_spStmtTimeout	->setFixedWidth (m_spStmtTimeout->sizeHint().width()) ;
#endif
	new QLabel (TR("Lock for update timeout"), layTimeout) ;
	m_spLockTimeout	= new QSpinBox	(0, 0x7fffffff, 1, layTimeout) ;
	m_spLockTimeout	->setValue	(m_lockTimeout >= 0 ? m_lockTimeout : 0) ;
	m_spLockTimeout	->setFixedWidth (m_spLockTimeout->sizeHint().width()) ;

	new QLabel (TR("Specify connect string"), layGeneral) ;
	m_teConnectStr	= new QTextEdit(layGeneral)	;
	m_teConnectStr->setText (m_connectStr) ;

//	layGeneral->addFiller () ;

#ifdef	__NOTYET
	m_cbGrants		= new QCheckBox (TR("Set grants on table"), layGrants) ;
	m_cbGrantSelect		= new QCheckBox (TR("Grant select"), 	    layGrants) ;
	m_cbGrantInsert		= new QCheckBox (TR("Grant insert"),	    layGrants) ;
	m_cbGrantUpdate		= new QCheckBox (TR("Grant update"),	    layGrants) ;
	m_cbGrantDelete		= new QCheckBox (TR("Grant delete"),	    layGrants) ;

	m_cbGrants		->setChecked	(m_grants     ) ;
	m_cbGrantSelect		->setChecked	(m_grantSelect) ;
	m_cbGrantInsert		->setChecked	(m_grantInsert) ;
	m_cbGrantUpdate		->setChecked	(m_grantUpdate) ;
	m_cbGrantDelete		->setChecked	(m_grantDelete) ;

	QHBox	*layTo		= new QHBox	(layGrants) ;
	new QLabel	(TR("Grant to"), layTo) ;
	m_leGrantTo		= new QLineEdit(layTo) ;

	m_cbGrantPopup		= new QCheckBox (TR("Show pop-up on creation"), layGrants) ;
	m_cbGrantPopup		->setChecked	(m_grantPopup) ;

	layGrants->addFiller() ;

	slotGrantsChanged	() ;

	connect
	(	m_cbGrants,
		SIGNAL	(toggled(bool)),
		SLOT	(slotGrantsChanged())
	)	;
#endif

	slotUseTimeoutChanged	() ;

	connect
	(	m_cbUseTimeouts,
		SIGNAL	(toggled(bool)),
		SLOT	(slotUseTimeoutChanged())
	)	;
}

void	KBOra10iAdvanced::slotGrantsChanged ()
{
#ifdef	__NOTYET
	bool	on	= m_cbGrants->isChecked () ;

	m_cbGrantSelect	->setEnabled (on) ;
	m_cbGrantInsert	->setEnabled (on) ;
	m_cbGrantUpdate	->setEnabled (on) ;
	m_cbGrantDelete	->setEnabled (on) ;
	m_leGrantTo	->setEnabled (on) ;
	m_cbGrantPopup	->setEnabled (on) ;
#endif
}

void	KBOra10iAdvanced::slotUseTimeoutChanged ()
{
#ifdef	__NOTYET
	m_spStmtTimeout->setEnabled (m_cbUseTimeouts->isChecked()) ;
#endif
	m_spLockTimeout->setEnabled (m_cbUseTimeouts->isChecked()) ;
}



/*  KBOra10iAdvanced							*/
/*  saveDialog	: Save results from dialog				*/
/*  (returns)	: void		:					*/

void	KBOra10iAdvanced::saveDialog ()
{
	m_showRowID 	   	= m_cbShowRowID 	->isChecked() ;
	m_showOra10iObjects	= m_cbShowOra10iObjects	->isChecked() ;
	m_useTimeouts	   	= m_cbUseTimeouts	->isChecked() ;
#ifdef	__NOTYET
	m_stmtTimeout      	= m_spStmtTimeout	->value    () ;
#endif
	m_lockTimeout      	= m_spLockTimeout	->value    () ;
	m_connectStr		= m_teConnectStr	->text	   () ;

#ifdef	__NOTYET
	m_grants	   = m_cbGrants		 ->isChecked() ;
	m_grantSelect	   = m_cbGrantSelect	 ->isChecked() ;
	m_grantInsert	   = m_cbGrantInsert	 ->isChecked() ;
	m_grantUpdate	   = m_cbGrantUpdate	 ->isChecked() ;
	m_grantDelete	   = m_cbGrantDelete	 ->isChecked() ;
	m_grantTo	   = m_leGrantTo	 ->text	    () ;
	m_grantPopup	   = m_cbGrantPopup	 ->isChecked() ;
#endif
}

/*  KBOra10iAdvanced							*/
/*  copy	: Replicate this object					*/
/*  (returns)	: KBOra10iAdvanced * : Replicated object			*/

KBDBAdvanced
	*KBOra10iAdvanced::copy ()
{
	KBOra10iAdvanced	*copy	= new KBOra10iAdvanced ()	;

	copy->m_showRowID		= m_showRowID		;
	copy->m_showOra10iObjects	= m_showOra10iObjects	;
	copy->m_useTimeouts		= m_useTimeouts 	;
#ifdef	__NOTYET
	copy->m_stmtTimeout		= m_stmtTimeout 	;
#endif
	copy->m_lockTimeout		= m_lockTimeout 	;
	copy->m_connectStr		= m_connectStr	 	;

#ifdef	__NOTYET
	copy->m_grants			= m_grants		;
	copy->m_grantSelect		= m_grantSelect		;
	copy->m_grantInsert		= m_grantInsert		;
	copy->m_grantUpdate		= m_grantUpdate		;
	copy->m_grantDelete		= m_grantDelete		;
	copy->m_grantTo			= m_grantTo		;
	copy->m_grantPopup		= m_grantPopup		;
#endif
	return	copy	;
}
