static	SQLINTEGER mapCRLF
	(	char		*buffer,
		SQLINTEGER	bufflen
	)
{
	SQLINTEGER p1	= 0 ;
	SQLINTEGER p2	= 0 ;

	while (bufflen > 1)
	{
		if ((buffer[p1] == '\r') && (buffer[p1 + 1] == '\n'))
		{
			buffer[p2] = '\n' ;
			p1	  += 2	  ;
			p2	  += 1	  ;
			bufflen	  -= 2	  ;
			continue  ;
		}

		buffer[p2] = buffer[p1]	;
		p1	  += 1 ;
		p2	  += 1 ;
		bufflen	  -= 1 ;
	}

	if (bufflen > 0)
	{	buffer[p2] = buffer[p1]	;
		p2	  += 1 ;
	}

	return	p2 ;
}

static	bool	fetchRowValues
	(	DBTYPE			*server,
		QTextCodec		*codec,
		SQLHSTMT		stmHandle,
		uint			nvals,
		KBValue			*values,
		KBType			**types,
		QValueList<SQLSMALLINT>	&cTypes,
		QValueList<SQLSMALLINT>	&dbTypes,
		KBError			&pError
	)
{
	for (uint colno = 0 ; colno < nvals ; colno += 1)
	{
		char	   	buffer[GETBUFSIZ + 8];
		SQLINTEGER 	bufflen		;
		SQLINTEGER 	bufflen2	;
		SQLRETURN 	odbcRC		;

		*(long*)(&buffer[GETBUFSIZ + 4]) = MAGIC;

		odbcRC = SQLGetData
			 (	stmHandle,
				colno + 1,
				cTypes[colno],
				buffer,
				GETBUFSIZ + GET_EXTRA,
				&bufflen
			 )	;

		if (!server->checkRCOK
			(	stmHandle,
				odbcRC,
				"Error fetching query value"
			))
		{
			pError = server->lastError();
			return	 false	;
		}

		KBType	*type	= types [colno] ;
		KBValue	&value	= values[colno] ;
		bool	binary  = false ;

		if (bufflen == SQL_NULL_DATA)
		{
			value	 = KBValue(type) ;
			continue ;
		}

		switch (dbTypes[colno])
		{
			case SQL_BIT	  :
				value	 = KBValue((int   )*(SQLCHAR     *)buffer, type) ;
				continue ;

			case SQL_SMALLINT :
				value	 = KBValue((int   )*(SQLSMALLINT *)buffer, type) ;
				continue ;

			case SQL_INTEGER :
				value	 = KBValue((int   )*(SQLINTEGER  *)buffer, type) ;
				continue ;
#if	0
			case SQL_BIGINT :
				value	 = KBValue((int   )*(SQLBIGINT   *)buffer, type) ;
				continue ;
#endif
			case SQL_REAL :
				value	 = KBValue((double)*(SQLREAL     *)buffer, type) ;
				continue ;

			case SQL_DOUBLE :
				value	 = KBValue((double)*(SQLDOUBLE   *)buffer, type) ;
				continue ;

			case SQL_DECIMAL :
			case SQL_NUMERIC :
				/* We have gotten the driver to		*/
				/* covnert to double for use!		*/
				value	 = KBValue((double)*(SQLDOUBLE   *)buffer, type) ;
				continue ;

			case SQL_TYPE_DATE 	:
			case SQL_DATE	   	:
				value	= KBValue
					  (	QString().sprintf("%04d-%02d-%02d",
							((DATE_STRUCT *)&buffer)->year,
							((DATE_STRUCT *)&buffer)->month,
							((DATE_STRUCT *)&buffer)->day),
						type
					  )	;
				continue  ;

			case SQL_TYPE_TIME 	:
			case SQL_TIME	   	:
				value	= KBValue
					  (	QString().sprintf("%02d:%02d:%02d",
							((TIME_STRUCT *)&buffer)->hour,										
							((TIME_STRUCT *)&buffer)->minute,
							((TIME_STRUCT *)&buffer)->second),
						type
					  )	;
				continue  ;

			case SQL_TYPE_TIMESTAMP :
			case SQL_TIMESTAMP	:
				value	= KBValue
					  (	QString().sprintf("%04d-%02d-%02d %02d:%02d:%02d",
							((TIMESTAMP_STRUCT *)&buffer)->year,
							((TIMESTAMP_STRUCT *)&buffer)->month,
							((TIMESTAMP_STRUCT *)&buffer)->day,
							((TIMESTAMP_STRUCT *)&buffer)->hour,
							((TIMESTAMP_STRUCT *)&buffer)->minute,
							((TIMESTAMP_STRUCT *)&buffer)->second),
						type
					  )	;
				continue  ;

			case SQL_CHAR 		:
			case SQL_VARCHAR	:
			case SQL_LONGVARCHAR	:
				break	;

			case SQL_BINARY		:
			case SQL_VARBINARY	:
			case SQL_LONGVARBINARY	:
				binary	= true	;
				break	;

#ifdef	SQL_BLOB
			case SQL_BLOB	:
			case SQL_CLOB	:
				binary	= true	;
				break	;
#endif
			default:
				value	 = KBValue(QString("UNKNOWN:%1").arg(dbTypes[colno]), type) ;
				continue ;
		}

		if(*(long*)(&buffer[GETBUFSIZ + 4]) != MAGIC)
		{
			fprintf
			(	stderr,
				DBTAG "QrySelect::getField -> %d: Marker was zapped!!\n",
				(int)bufflen
			)	;
			exit (1);
		}


		/* Handle the variable-length types. The first case is	*/
		/* an optimisation where all the data is already	*/
		/* available, which is (hopefully) the usual case.	*/
		if ((odbcRC == SQL_SUCCESS) && (bufflen <= GETBUFSIZ))
		{
			/* If the data is binary then it may need	*/
			/* packing; if not then we may need to do	*/
			/* CRLF->LF mapping.				*/
			if (binary)
				bufflen = packBinary (buffer, bufflen) ;

			if (!binary && server->mapCRLF())
				bufflen	= mapCRLF    (buffer, bufflen) ;

			value	= KBValue (buffer, bufflen, type, codec) ;
			continue  ;
		}

		fprintf
		(	stderr,
			DBTAG "QrySelect::getField: overrun (%d/%d) rc=%d\n",
			GETBUFSIZ,
			(int)bufflen,
			(int)odbcRC
		)	;

		QByteArray data    (bufflen + GETBUFSIZ) ;
		memcpy	(data.data(), buffer, GETBUFSIZ) ;

		uint	   dptr = GETBUFSIZ ;
		do
		{
			odbcRC = SQLGetData
				   (	stmHandle,
					colno + 1,
					cTypes[colno],
					buffer,
					GETBUFSIZ + GET_EXTRA,
					&bufflen2
		 		   )	;

			fprintf
			(	stderr,
				"KBDB2CLIQrySelect::getField: continue (%d/%d) rc=%d\n",
				GETBUFSIZ,
				(int)bufflen2,
				(int)odbcRC
			)	;

			if (!server->checkRCOK
				(	stmHandle,
					odbcRC, "Error fetching query value"
				))
			{
				pError	= server->lastError () ;
				value	= KBValue() ;
				goto	nextCol     ;
			}

			memcpy	(data.data() + dptr, buffer, GETBUFSIZ) ;
			dptr	+= GETBUFSIZ ;
		}
		while	((odbcRC == SQL_SUCCESS_WITH_INFO) || (bufflen2 >= GETBUFSIZ)) ;

		fprintf
		(	stderr,
			DBTAG "QrySelect::rowExists: done %d (binary=%d)\n",
			(int)bufflen,
			binary
		)	;

		/* If the data is binary then it may need packing; if	*/
		/* not then we may need to do CRLF->LF mapping.		*/
		if (binary)
			bufflen = packBinary (data.data(), bufflen) ;

		if (!binary && server->mapCRLF())
			bufflen	= mapCRLF    (data.data(), bufflen) ;

		value	= KBValue(data.data(), bufflen, type, codec) ;

		nextCol : ;
	}

	return	true	;
}

bool	QRYSELECT::rowExists
	(	uint		qrow,
		bool	
	)
{
	SQLRETURN odbcRC	;
	KBValue	  value		;

//	fprintf
//	(	stderr,
//		DBTAG "CLIQrySelect::rowExists: %d %d %d\n",
//		qrow,
//		m_nRows,
//		m_CRow
//	)	;

	/* If the number of rows is now known (ie., we have previously	*/
	/* retrieved all rows) then we can answer immediately.		*/
	if (m_nRows != KBSQLSelect::RowsUnknown)
		return	(int)qrow < m_nRows ;


	/* We will need to load data up to the required row since we	*/
	/* can only fetch data in a row-column-serial manner. Values	*/
	/* fetched are stored in the cache.				*/
	while (m_CRow < (int)qrow)
	{
//		fprintf
//		(	stderr,
//			DBTAG "QrySelect::rowExists: preload %u\n",
//			qrow
//		)	;

		odbcRC = SQLFetch (m_stmHandle) ;
		if (odbcRC == SQL_NO_DATA)
		{
//			fprintf
//			(	stderr,
//				DBTAG "QrySelect::rowExists: out of data at %d\n",
//				m_CRow
//			)	;
			m_nRows	= m_CRow ;
			break	;
		}

		if (!m_pServer->checkRCOK(m_stmHandle, odbcRC, "Error fetching query row"))
		{
			m_lError = m_pServer->lastError();
			break	 ;
		}

		m_CRow	+= 1 ;

		KBValue	*values	= new KBValue[getNumFields()] ;

		if (!fetchRowValues
			(	m_pServer,
				m_codec,
				m_stmHandle,
				getNumFields(),
				values,
				m_types,
				m_cTypes,
				m_dbTypes,
				m_lError
			))
		{
			delete	[] values;
			return	false	 ;
		}

		putInCache (m_CRow, values) ;
	}

//	fprintf
//	(	stderr,
//		DBTAG "QrySelect::rowExists: %u %d\n",
//		qrow,
//		m_CRow
//	)	;

	return	(m_CRow >= 0) && ((int)qrow <= m_CRow)	;
}
