/***************************************************************************
    file	         : kb_odbcval.cpp
    copyright            : (C) 1999,2000,2001 by Mike Richardson
			   (C) 2000,2001 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


/*  NOTE								*/
/*  ----								*/
/*  This file contains code that is common to the ODBC and DB2 drivers.	*/
/*  It is #included and *not* part of a linked library, in case of	*/
/*  subtle differences in constant values ans such like.		*/


/*  KBODBCValue								*/
/*  KBODBCValue	: Constructor for ODBC binding value object		*/
/*  value	: const KBValue & : Underlying value			*/
/*  codec	: QTextCodec *	  : Non-default codec			*/
/*  (returns)	: KBODBCValue     :					*/

KBODBCValue::KBODBCValue
	(	const KBValue	&value,
		QTextCodec	*codec
	)
{
	/* NOTE:							*/
	/* This code assumes that the argument object exists until	*/
	/* after this object is destroyed, since in the case of some	*/
	/* types it will contain a pointer into the value.		*/
	fprintf
	(	stderr,
		"KBODBCValue::KBODBCValue: %d->%s [%s]\n",
		value.getType()->getIType(),
		(cchar *)value.getType()->getDescrip (true),
		(cchar *)value.getRawText()
	)	;

	m_alloc	= 0;
	memset ((void *)&m_d, 0, sizeof(m_d)) ;

	switch (value.getType()->getIType())
	{
		case KB::ITFixed	:
		{
			m_d.fixed	= value.getRawText().toInt   () ;
			m_ptype		= SQL_INTEGER		;
			m_vtype		= SQL_C_LONG		;
			m_vptr		= &m_d.fixed		;
			m_vlen		= sizeof(SQLINTEGER)	;
			m_slind		= m_vlen		;
		}
		break	;

		case KB::ITFloat	:
		{
			m_d.dbl		= value.getRawText().toDouble() ;
			m_ptype		= SQL_DOUBLE		;
			m_vtype		= SQL_C_DOUBLE		;
			m_vptr		= &m_d.dbl		;
			m_vlen		= sizeof(SQLDOUBLE)	;
			m_slind		= m_vlen		;
		}
		break	;

		case KB::ITDate		:
		{
			const KBDateTime *dt = value.getDateTime() ;
			if (dt != 0)
			{
				m_d.date.year 	= dt->getDate().year	() ;
				m_d.date.month	= dt->getDate().month	() ;
				m_d.date.day	= dt->getDate().day	() ;
			}
			m_ptype		= SQL_DATE		;
			m_vtype		= SQL_C_DATE		;
			m_vptr		= &m_d.date		;
			m_vlen		= sizeof(DATE_STRUCT)	;
			m_slind		= m_vlen		;
		}
		break	;

		case KB::ITTime		:
		{
			const KBDateTime *dt = value.getDateTime() ;
			if (dt != 0)
			{
				m_d.time.hour 	= dt->getTime().hour	() ;
				m_d.time.minute	= dt->getTime().minute	() ;
				m_d.time.second	= dt->getTime().second 	() ;
			}
			m_ptype		= SQL_TIME		;
			m_vtype		= SQL_C_TIME		;
			m_vptr		= &m_d.time		;
			m_vlen		= sizeof(TIME_STRUCT)	;
			m_slind		= m_vlen		;
		}
		break	;

		case KB::ITDateTime		:
		{
			const KBDateTime *dt = value.getDateTime() ;
			if (dt != 0)
			{
				m_d.stamp.year 	= dt->getDate().year	() ;
				m_d.stamp.month	= dt->getDate().month	() ;
				m_d.stamp.day	= dt->getDate().day	() ;
				m_d.stamp.hour 	= dt->getTime().hour	() ;
				m_d.stamp.minute= dt->getTime().minute	() ;
				m_d.stamp.second= dt->getTime().second 	() ;
			}

			m_ptype		= SQL_TIMESTAMP		;
			m_vtype		= SQL_C_TIMESTAMP	;
			m_vptr		= &m_d.stamp		;
			m_vlen		= sizeof(TIMESTAMP_STRUCT) ;
			m_slind		= m_vlen		;
		}
		break	;

		case KB::ITBinary	:
		{
			m_ptype		= SQL_BINARY		;
			m_vtype		= SQL_C_BINARY		;
			m_vptr		= (void *)value.dataPtr() ;
			m_vlen		= value.dataLength()	;
			m_slind		= m_vlen		;
		}
		break	;

		case KB::ITUnknown	:
		case KB::ITString	:
		default			:
		{
			m_ptype		= SQL_CHAR		;
			m_vtype		= SQL_C_CHAR		;

			if (codec != 0)
			{
				QString  utf8  = QString::fromUtf8  (value.dataPtr(), value.dataLength()) ;
				QCString local = codec->fromUnicode (utf8) ;
				char	 *buff = (char *)malloc(local.length() + 1) ;

				m_vptr	= buff ;
				m_vlen	= local.length() ;
				m_alloc = buff ;

				memcpy	(buff, local.data(), local.length()) ;
				buff[local.length()]= 0 ;
			}
			else
			{
				m_vptr	= (void *)value.dataPtr() ;
				m_vlen	= value.dataLength()	;
			}

			m_slind		= m_vlen ;
		}
		break	;
	}

	if (value.isNull())
	{	m_vlen	= 0		;
		m_slind = SQL_NULL_DATA ;
	}
}

/*  KBODBCValue								*/
/*  ~KBODBCValue: Destructor for ODBC binding value object		*/
/*  (returns)	:		:					*/

KBODBCValue::~KBODBCValue()
{
	if (m_alloc != 0) free (m_alloc) ;
}

