/*  KBODBCValue								*/
/*  -----------								*/
/*  When values are bound to parameters (placeholders) the buffer	*/
/*  storing the value must remain until after the query has been	*/
/*  executed. This class is used to convert the Rekall value into the	*/
/*  correct format for ODBC, and so hang on to it as long as is	needed	*/

class	KBODBCValue
{
	union
	{	SQLINTEGER		fixed	 ;
		SQLDOUBLE		dbl	 ;
		TIME_STRUCT		time	 ;
		DATE_STRUCT		date	 ;
		TIMESTAMP_STRUCT	stamp	 ;
	}	m_d	;

	void		*m_alloc	;

	SQLSMALLINT	m_ptype		;
	SQLSMALLINT	m_vtype		;
	SQLPOINTER	m_vptr		;
	SQLINTEGER	m_vlen		;
	SQLINTEGER	m_slind		;


public  :

	KBODBCValue	(const KBValue &, QTextCodec *) ;
       ~KBODBCValue	()	;

	inline	SQLSMALLINT	ptype	() { return  m_ptype ; }
	inline	SQLSMALLINT	vtype	() { return  m_vtype ; }
	inline	SQLPOINTER	vptr	() { return  m_vptr  ; }
	inline	SQLINTEGER	vlen	() { return  m_vlen  ; }
	inline	SQLINTEGER	*slind	() { return &m_slind ; }
}	;
