/***************************************************************************
    file	         : kb_about.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>
#include	<stdlib.h>
#include	<errno.h>
#include	<time.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qevent.h>
#include	<qwidget.h>
#include	<qwidgetlist.h>
#include	<qguardedptr.h>
#include	<qapplication.h>
#include 	<qpalette.h>
#include 	<qtimer.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_attr.h"
#include	"kb_attrdict.h"
#include	"kb_dblink.h"
#include	"kb_dbinfo.h"
#include	"kb_node.h"
#include	"kb_display.h"
#include	"kb_prompt.h"
#include	"kb_gui.h"
#include	"kb_location.h"
#include	"kb_viewer.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_director.h"
#include	"kbase.h"
#include	"kb_dbdlg.h"
#include	"kb_serverinfo.h"
#include	"kb_script.h"
#include	"kb_build.h"

static	cchar	*licenseText =

"<qt>"
"Copyright:<br/>"
"(C) 1999,2000,2001,2002,2003 by Mike Richardson<br/>"
"(C) 2000,2001,2002,2003 by theKompany.com<br/>"
"(C) 2001,2002,2003 by John Dean<br/>"
"This file is released under the terms of<br/>"
"the GNU General Public License, version 2. The<br/>"
"copyright holders retain the right to release<br/>"
"this code under diffenent non-exclusive licences.<br/>"
"EMail: mike@quaking.demon.co.uk<br/>"                                   
"</qt>"
;


static	QString	pluginsText ()
{
	return	QString
		(	"<qt>"
			"<p>"
			"Please visit "
			"<a href=\"http://www.rekall.a-i-s.co.uk/\">www.rekall.a-i-s.co.uk</a> "
			"for up-to-date information on additional plugins"
			"</p>"
			"<p>"
			"<table>"
			"<tr><td><b>%1</b></td><td></td><td>" __KB_BUILD_IDENT "</td></tr>"
			"%2"
			"%3"
			"%4"
			"</table>"
			"</p>"
			"</qt>"
		)
#if	__KB_RUNTIME
		.arg("RekallRT")
#else
		.arg("Rekall")
#endif
		.arg(KBDBaseDlg  ::getIdentStrings())
		.arg(KBServerInfo::getIdentStrings())
		.arg(KBScriptIF  ::getIdentStrings()) ;
}

void	KBaseApp::showAboutApplication ()
{
	showAboutDialog (false) ;
}

#if	__KB_KDE

#include	<kmenubar.h>
#include	<kpopupmenu.h>
#include	<kaboutapplication.h>

void	KBaseApp::fixHelpMenu
	(	KBDirector	&director
	)
{
	KMenuBar *mb = menuBar() ;
	int	 mid ;

	for (uint idx = 0 ; idx < mb->count() ; idx += 1)
	    if ((mid = mb->idAt (idx)) != -1)
		if (mb->text(mid) == i18n("&Help"))
		{	mb->removeItem (mid) ;
			mb->insertItem (i18n("&Help"), customHelpMenu()) ;
			customHelpMenu()->insertSeparator () ;
			customHelpMenu()->insertItem  (getSmallIcon  ("rekall"), TR("Plugins"), &director, SLOT(showHelpPlugins())) ;
			break	;
		}


}

void	KBaseApp::showAboutDialog
	(	bool	showPlugins
	)
{
	static	KAboutApplication *aboutApp ;
	static	QFrame		  *license  ;
	static	QFrame		  *plugins  ;

	if (aboutApp == 0)
	{
		aboutApp = new KAboutApplication
			   (	instance()->aboutData(),
				this,
				"about",
				false
			   )	;

		license  = aboutApp->addLicensePage
			   (	TR("License"),
				licenseText
			   )	;

		plugins  = aboutApp->addTextPage
			   (	TR("Plugins"),
			   	pluginsText()
			   )	;
	}

	aboutApp->show () ;
	if (showPlugins) aboutApp->showPage (aboutApp->pageIndex (plugins)) ;
}

#endif	// __KB_KDE

#if	__KB_TKC

#include	<qtabdialog.h>
#include	<qtextview.h>
#include	<qtextbrowser.h>


class	KBAboutDlg : public QTabDialog
{
public	:

	inline	KBAboutDlg ()
		:
		QTabDialog (0, 0, true)
	{
	}

	void	show ()	;
}	;

void	KBAboutDlg::show ()
{
#if	__KB_EMBEDDED
	static	bool	inShow	= false	;

	if	(!inShow)
	{
		inShow	= true	;
		showMaximized() ;
		inShow	= false	;
		return	;
	}
#endif
	QTabDialog::show()	;
}



void	KBaseApp::fixHelpMenu
	(	KBDirector	&
	)
{
}

void	KBaseApp::showAboutDialog
	(	bool	showPlugins
	)
{
	static	QTabDialog	*aboutApp ;

	if (aboutApp == 0)
	{
		QTextView	*plugins ;

		aboutApp	= new KBAboutDlg() ;
		plugins 	= new QTextView	(aboutApp) ;

		plugins->setTextFormat(Qt::RichText ) ;
		plugins->setText      (pluginsText()) ;


		QTextView	*about	 ;
		QTextView	*authors ;
		QTextView	*license ;

		about		= new QTextView	(aboutApp) ;
		authors 	= new QTextView	(aboutApp) ;
		license 	= new QTextView (aboutApp) ;

		about	->setTextFormat(Qt::RichText) ;
		about   ->setText
		(	TR("RekallQT: A QT database front end") + "<br/>"
			"Release " RELEASE BUILD "<br/>"
		        "(c) 2000,2001,2002,2003 <br/>"
		);

		authors ->setTextFormat(Qt::RichText) ;
		authors ->setText
		(	"<qt>"
			"<table>"
			"<tr><td>Mike Richardson</td><td><a href=\"mailto:mike@quaking.demon.co.uk\">mike@quaking.demon.co.uk</a></td></tr>"
			"<tr><td>John Dean</td><td><a href=\"mailto:john@rygannon.com\">john@rygannon.com</a></td></tr>"
			"<tr><td colspan=2>Bits and pieces by other people at theKompany.com</td></tr>"
			"<table>"
			"</qt>"
		)	;

		license ->setTextFormat(Qt::RichText) ;
		license ->setText  (licenseText) ;

		aboutApp->addTab   (about,   TR("About"  )) ;
		aboutApp->addTab   (authors, TR("Authors")) ;
		aboutApp->addTab   (license, TR("License")) ;
		aboutApp->addTab   (plugins, TR("Plugins")) ;

		aboutApp->showPage (showPlugins ? (QWidget *)plugins : (QWidget *)about) ;

#if	! __KB_EMBEDDED
		plugins ->setMinimumSize (500, 250) ;
#endif
	}

	aboutApp->exec () ;
}

#endif	// __KB_TKC
