/***************************************************************************
    file	         : kb_dbadvanceddlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifdef		_WIN32
#include	"kb_dbadvanceddlg.h"
#else
#include	"kb_dbadvanceddlg.moc"
#endif

#include	"tk_messagebox.h"


static	cchar	*codecNames[] =
{
	"UTF8",
	"BIG5",
	"CP 874",
	"CP 1250",
	"CP 1251",
	"CP 1252",
	"CP 1253",
	"CP 1254",
	"CP 1255",
	"CP 1256",
	"CP 1257",
	"CP 1258",
	"EUCJP",
	"EUCKR",
	"GBK",
	"JIS7",
	"KOI8-R",
	"KOI8-U",
	"SHIFT-JIS",
	"ISO8859-1",
	"ISO8859-2",
	"ISO8859-3",
	"ISO8859-4",
	"ISO8859-5",
	"ISO8859-6",
	"ISO8859-7",
	"ISO8859-8",
	"ISO8859-8-I",
	"ISO8859-9",
	"ISO8859-10",
	"ISO8859-13",
	"ISO8859-14",
	"ISO8859-15",
	"TIS-620",
	"TSCII",
	0
}	;

static	bool	checkCodec
	(	const QString	&encoding,
		const QString	&msg
	)
{
	if (!encoding.isEmpty())
	{
		QTextCodec *codec = QTextCodec::codecForName  (encoding) ;

		if (codec == 0)
		{
			TKMessageBox::sorry
			(	0,
				QString	(TR("Cannot find %1 codec for '%1'"))
					.arg(msg)
					.arg(encoding),
				TR("Encoding")
			)	;
			return	false	;
		}
	}

	return	true	;
}


/*  ------------------------------------------------------------------  */


/*  KBDBAdvancedDlg							*/
/*  KBDBAdvancedDlg							*/
/*		: Constructor for advanced server options dialog	*/
/*  svInfo	: KBServerInfo *  : Server information			*/
/*  opts	: uint		  : Driver option flags			*/
/*  (returns)	: KBDBAdvancedDlg :					*/

KBDBAdvancedDlg::KBDBAdvancedDlg
	(	KBServerInfo	*svInfo,
		uint		opts
	)
	:
	_KBDialog	(TR("Advanced"), true),
	m_svInfo	(svInfo),
	m_opts		(opts),
	m_tabWidget	(this),
	m_bOK		(this),
	m_bCancel	(this),
	m_mainPage	(&m_tabWidget),
	m_initPage	(&m_tabWidget),
	m_noRekallTables(&m_mainPage),
	m_showAllTables	(&m_mainPage),
	m_cacheTables	(&m_mainPage),
	m_nullUserPwd	(&m_mainPage),
	m_pkReadOnly	(&m_mainPage),
	m_fakeKeys	(&m_mainPage),
	m_readOnly	(&m_mainPage),
	m_autoForm	(&m_mainPage),
	m_dataEncoding	(&m_mainPage),
	m_objEncoding	(&m_mainPage),
	m_initSQL	(&m_initPage)
#ifndef	_WIN32
	,
	m_sshTarget	(&m_mainPage)
#endif
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;
	layMain->addWidget  (&m_tabWidget) ;

	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;
	layButt->addStretch () ;
	layButt->addWidget  (&m_bOK    ) ;
	layButt->addWidget  (&m_bCancel) ;

	m_bOK	 .setText   (TR("OK"	)) ;
	m_bCancel.setText   (TR("Cancel")) ;

	m_tabWidget.addTab  (&m_mainPage, TR("Common")) ;
	m_tabWidget.addTab  (&m_initPage, TR("Initial SQL")) ;

	QGridLayout	*layPage = new QGridLayout (&m_mainPage) ;

	m_noRekallTables.setText    (TR("Do not create rekall-specific tables")) ;
	m_noRekallTables.setChecked (m_svInfo->m_noRekallTables) ;
	layPage->addWidget (&m_noRekallTables, 0, 1) ;

	m_showAllTables .setText    (TR("Show all tables")) ;
	m_showAllTables .setChecked (m_svInfo->m_showAllTables) ; 
	layPage->addWidget (&m_showAllTables,  1, 1) ;

	m_cacheTables   .setText    (TR("Cache table information")) ;
	m_cacheTables   .setChecked (m_svInfo->m_cacheTables) ;
	layPage->addWidget (&m_cacheTables,    2, 1) ;

	m_nullUserPwd   .setText    (TR("Accept empty user name/password")) ;
	m_nullUserPwd   .setChecked (m_svInfo->m_nullUserPwd) ;
	layPage->addWidget (&m_nullUserPwd,    3, 1) ;

	m_pkReadOnly    .setText    (TR("Primary keys are read only")) ;
	m_pkReadOnly    .setChecked (m_svInfo->m_pkReadOnly ) ;
	layPage->addWidget (&m_pkReadOnly,     4, 1) ;

	m_fakeKeys      .setText    (TR("Fake unique keys for insertion")) ;
	m_fakeKeys      .setChecked (m_svInfo->m_fakeKeys   ) ;
	layPage->addWidget (&m_fakeKeys,       5, 1) ;

	m_readOnly      .setText    (TR("Database is read-only")) ;
	m_readOnly      .setChecked (m_svInfo->m_readOnly   ) ;
	layPage->addWidget (&m_readOnly,       6, 1) ;

	QLabel	*lblAutoForm= new QLabel (&m_mainPage) ;
	layPage->addWidget (lblAutoForm,     7, 0) ;
	layPage->addWidget (&m_autoForm,     7, 1) ;
	lblAutoForm->setText(TR("AutoStart form")) ;
	m_autoForm	.setText    (m_svInfo->m_autoForm) ;

	QLabel	*lblDataEnc = new QLabel (&m_mainPage) ;
	layPage->addWidget (lblDataEnc,      8, 0) ;
	layPage->addWidget (&m_dataEncoding, 8, 1) ;
	lblDataEnc->setText (TR("Data Encoding"))  ;

	QLabel	*lblObjEnc  = new QLabel (&m_mainPage) ;
	layPage->addWidget (lblObjEnc,       9, 0) ;
	layPage->addWidget (&m_objEncoding,  9, 1) ;
	lblObjEnc ->setText (TR("Object Encoding"));


	QVBoxLayout	*layInit = new QVBoxLayout (&m_initPage) ;
	layInit->addWidget(&m_initSQL) ;
	m_initSQL.setText (m_svInfo->m_initSQL) ;

#ifndef	_WIN32
	QLabel	*lblTarget  = new QLabel (&m_mainPage) ;
	layPage->addWidget  (lblTarget,       10, 0) ;
	layPage->addWidget  (&m_sshTarget,    10, 1) ;
	lblTarget ->setText (TR("SSH Tunneling"));
	m_sshTarget.setText (m_svInfo->m_sshTarget) ; 

	if ((m_opts & AF_SSHTUNNEL) == 0)
		m_sshTarget.setEnabled (false) ;
#endif
	m_dataEncoding.insertItem("") ; 
	m_objEncoding .insertItem("") ; 

	int atd = -1 ;
	int ato = -1 ;
	for (cchar **cnp = &codecNames[0] ; *cnp != 0 ; cnp += 1)
	{	
		if (*cnp == m_svInfo->m_dataEncoding) atd = m_dataEncoding.count() ;
		if (*cnp == m_svInfo->m_objEncoding ) ato = m_objEncoding .count() ;

		m_dataEncoding.insertItem(*cnp) ; 
		m_objEncoding .insertItem(*cnp) ; 

		QTextCodec *tc = QTextCodec::codecForName(*cnp) ;
		if (tc == 0)
			fprintf
			(	stderr,
				"KBDBAdvancedDlg::KBDBAdvancedDlg: no codec [%s]\n",
				*cnp
			)	;
	}

	m_dataEncoding.setEditable (true) ;
	m_objEncoding .setEditable (true) ;

	if (atd >= 0)
		m_dataEncoding.setCurrentItem(atd) ;
	else
		if (!m_svInfo->m_dataEncoding.isEmpty())
			m_dataEncoding.setEditText (m_svInfo->m_dataEncoding) ;

	if (ato >= 0)
		m_objEncoding .setCurrentItem(ato) ;
	else
		if (!m_svInfo->m_objEncoding .isEmpty())
			m_objEncoding .setEditText (m_svInfo->m_objEncoding ) ;



	layPage->setRowStretch (7, 1) ;

	if (m_svInfo->m_advanced != 0)
		m_svInfo->m_advanced->setupDialog (&m_tabWidget) ;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK	())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
}

/*  KBDBAdvancedDlg							*/
/*  ~KBDBAdvancedDlg							*/
/*		: Destructor for advanced server options dialog		*/
/*  (returns)	:		:					*/

KBDBAdvancedDlg::~KBDBAdvancedDlg ()
{
}

/*  KBDBAdvancedDlg							*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void							*/

void	KBDBAdvancedDlg::clickOK ()
{
	QString	   dataEnc    = m_dataEncoding.currentText() ;
	QString	   objEnc     = m_objEncoding .currentText() ;

	if (!checkCodec (dataEnc, TR("data  "))) return ;
	if (!checkCodec (objEnc,  TR("object"))) return ;

	m_svInfo->m_noRekallTables = m_noRekallTables.isChecked  () ;
	m_svInfo->m_showAllTables  = m_showAllTables .isChecked  () ;
	m_svInfo->m_cacheTables	   = m_cacheTables   .isChecked  () ;
	m_svInfo->m_nullUserPwd    = m_nullUserPwd   .isChecked  () ;
	m_svInfo->m_pkReadOnly     = m_pkReadOnly    .isChecked  () ;
	m_svInfo->m_fakeKeys       = m_fakeKeys      .isChecked  () ;
	m_svInfo->m_readOnly	   = m_readOnly	     .isChecked  () ;
	m_svInfo->m_autoForm       = m_autoForm.text() ;
	m_svInfo->m_initSQL	   = m_initSQL .text() ;
	m_svInfo->m_dataEncoding   = dataEnc ;
	m_svInfo->m_objEncoding    = objEnc  ;

#ifndef	_WIN32
	m_svInfo->m_sshTarget	   = m_sshTarget.text () ;
#endif
	if (m_svInfo->m_advanced != 0)
		m_svInfo->m_advanced->saveDialog() ;

	done	(1) ;
}

/*  KBDBAdvancedDlg							*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void							*/

void	KBDBAdvancedDlg::clickCancel ()
{
	done	(0) ;
}


