/***************************************************************************
    file	         : kb_dbadvanceddlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DBADVANCEDDLG_H
#define	__KB_DBADVANCEDDLG_H

#include	<qcheckbox.h>
#include	<qcombobox.h>
#include	<qlineedit.h>
#include	<qtextedit.h>
#include	<qtabwidget.h>

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_serverinfo.h"
#include	"kb_dialog.h"

/*  KBDBAdvancedDlg							*/
/*  ---------------							*/
/*  Basic advanced server options dialog. This handles the common	*/
/*  settings, and has support for the drivers to add their own specific	*/
/*  pages under additional tabs.					*/

class	KBDBAdvancedDlg : public _KBDialog
{
	Q_OBJECT

	KBServerInfo	*m_svInfo		;
	uint		m_opts			;

	QTabWidget	m_tabWidget		;
	QPushButton	m_bOK			;
	QPushButton	m_bCancel		;

	QWidget		m_mainPage		;
	QWidget		m_initPage		;
	QCheckBox	m_noRekallTables	;
	QCheckBox	m_showAllTables		;
	QCheckBox	m_cacheTables		;
	QCheckBox	m_nullUserPwd		;
	QCheckBox	m_pkReadOnly		;
	QCheckBox	m_fakeKeys		;
	QCheckBox	m_readOnly		;
	QLineEdit	m_autoForm		;
	QComboBox	m_dataEncoding		;
	QComboBox	m_objEncoding		;
	QTextEdit	m_initSQL		;
#ifndef	_WIN32
	QLineEdit	m_sshTarget		;
#endif

protected slots :

	void		clickOK		()	;
	void		clickCancel	()	;
public	:

	KBDBAdvancedDlg (KBServerInfo *, uint)	;
       ~KBDBAdvancedDlg () ;
}	;

#endif	// __KB_DBADVANCEDDLG_H
