/***************************************************************************
    file	         : kb_director.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DIRECTOR_H
#define	__KB_DIRECTOR_H

#include	<qobject.h>
#include	<qwidget.h>
#include	<qdict.h>

#include	"tk_icons.h"
#include	"tk_messagebox.h"

#include	"kb_part.h"


class	KBaseApp 	;
class	KBasePart	;

class	KBDirector : public QObject
{
	Q_OBJECT

	QList<KBasePart>	m_partList	;
	QDict<QWidget>		m_windowDict	;


	KBaseApp	*getKBaseApp	() ;

protected slots :

	void		partGone	() ;

public	:

	void		addPart		(KBasePart *) ;
	void		dropPart	(KBasePart *) ;
	void		alterPart	(KBasePart *) ;

public	slots	:

	void		showOptions	() ;
	void		showQueryLog	() ;
	void		showEventLog	() ;
	void		showScriptLog	() ;
	void		showDebugger	() ;
	void		openDatabase	() ;
	void		newDatabase	() ;
	void		openRecent	(const TKURL   &) ;
	void		quit		() ;

	void		showHelpContents() ;
	void		showHelpAbout	() ;
	void		showHelpPlugins () ;
	void		showHelpIndex	();
	void		showHelpSearch	();

	void		loadWindowList	() ;

	void		playScore	() ;
	void		package		() ;
	void		showWindow	(const QString &) ;
}	;

#endif	// __KB_DIRECTOR_H
