/***************************************************************************
    file	         : kb_eventlog.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_EVENTLOG_H
#define  _KB_EVENTLOG_H


#include	<qlistview.h>
#include	<qtextview.h>
#include 	<qsplitter.h>

#include	"kb_classes.h"
#include	"kb_part.h"


/*  KBEventLogEntry							*/
/*  ---------------							*/
/*  QListViewItem derived class, used to store additional event		*/
/*  inforamation.							*/

class	KBEventLogEntry : public QListViewItem
{
	QStringList	m_args	;
	QStringList	m_types	;
	bool		m_extra	;

public	:

	KBEventLogEntry
	(	QListView	*,
		QListViewItem	*,
		uint		,
		const QString	&,
		const QString	&,
		const QString	&,
		const QString	&,
		uint		,
		const KBValue	*
	)	;


	void	showArgs	 (QListView *) ;
}	;



/*  KBEventLog								*/
/*  ----------								*/
/*  This class provides a event logging window, where the number of	*/
/*  events is limited to some value, and new events are appended at	*/
/*  the end.								*/

class	KBEventLog : public KBasePart
{
	Q_OBJECT

	QSplitter	*m_split  ;
	QListView	*m_args	  ;	/* Event arguments		*/
	QListView	*m_log	  ;	/* Event list			*/
	KBaseGUI	*m_gui	  ;	/* GUI for this window		*/
	TKToggleAction	*m_action ;	/* GUI show/hide action		*/
	uint		m_count	  ;	/* Event count			*/
	QListViewItem	*m_last	  ;	/* Last inserted item		*/

private slots :

	void		clickEvent	(QListViewItem *) ;
	void		clearLog	() ;

public	:

		 KBEventLog (QWidget *, const QString &, TKToggleAction *) ;
	virtual	~KBEventLog () ;

	virtual	bool	queryClose	() ;

	void		*logEvent
			(	const QString	&,
				const QString	&,
				const QString	&,
				const QString	&,
				uint		,
				const KBValue	*
			)	;
	void		logEventResult
			(	const KBValue	&,
				bool		,
				void		*
			)	;
}	;

#endif // _KB_EVENTLOG_H
