/***************************************************************************
    file	         : kb_quickdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#ifndef 	_WIN32
#include	"kb_quickdlg.moc"
#else
#include 	"kb_quickdlg.h"
#endif

#include	"kb_dbinfo.h"
#include	"kb_serverinfo.h"
#include	"kb_filelist.h"
#include	"kb_scriptlist.h"
#include	"kb_dbdociter.h"


static	QString	lastType	;
static	QString	lastServer	;
static	QString	lastObject	;


static	void	setLastValue
	(	QComboBox	&combo,
		const QString	&value
	)
{
	for (int idx = 0 ; idx < combo.count() ; idx += 1)
		if (combo.text (idx) == value)
		{	combo.setCurrentItem (idx) ;
			break	;
		}
}

/*  KBQuickDlg								*/
/*  KBQuickDlg	: Constructor for quick selection dialog		*/
/*  dbInfo	: KBDBInfo *		: Database information		*/
/*  allParts	: QStringList &		: List of all part names	*/
/*  fileDict	: QDict<KBFileList>   & : List of main parts		*/
/*  scriptDict	: QDict<KBScriptList> & : List of script languages	*/
/*  (returns)	: KBQuickDlg		:				*/

KBQuickDlg::KBQuickDlg
	(	KBDBInfo		*dbInfo,
		QStringList		&allParts,
		QDict<KBFileList>	&fileDict,
		QDict<KBScriptList>	&scriptDict
	)
	:
	_KBDialog	(TR("Select Object"), true),
	m_lType		(this),
	m_lServer	(this),
	m_lObject	(this),
	m_cbType	(this),
	m_cbServer	(this),
	m_cbObject	(this),
	m_bDelete	(this),
	m_bCreate	(this),
	m_bCancel	(this),
	m_bOpen		(this),
	m_dbInfo	(dbInfo),
	m_fileDict	(fileDict),
	m_scriptDict	(scriptDict)
{
	m_layMain	= new QVBoxLayout (this) ;
	m_laySelect	= new QGridLayout (m_layMain) ;
	m_layButt	= new QHBoxLayout (m_layMain) ;

	m_laySelect->addWidget (&m_lType,    0, 0) ;
	m_laySelect->addWidget (&m_lServer,  1, 0) ;
	m_laySelect->addWidget (&m_lObject,  2, 0) ;
	m_laySelect->addWidget (&m_cbType,   0, 1) ;
	m_laySelect->addWidget (&m_cbServer, 1, 1) ;
	m_laySelect->addWidget (&m_cbObject, 2, 1) ;

	m_layButt  ->addWidget (&m_bDelete) ;
	m_layButt  ->addWidget (&m_bCreate) ;
	m_layButt  ->addStretch()	    ;
	m_layButt  ->addWidget (&m_bCancel) ;
	m_layButt  ->addWidget (&m_bOpen  ) ;

	connect	(&m_bDelete,  SIGNAL(clicked()), SLOT(clickDelete())) ;
	connect	(&m_bCreate,  SIGNAL(clicked()), SLOT(clickCreate())) ;
	connect	(&m_bCancel,  SIGNAL(clicked()), SLOT(clickCancel())) ;
	connect	(&m_bOpen,    SIGNAL(clicked()), SLOT(clickOpen  ())) ;

	connect	(&m_cbType,   SIGNAL(activated(int)), SLOT(userChange())) ;
	connect	(&m_cbServer, SIGNAL(activated(int)), SLOT(userChange())) ;

	m_lType  .setText (TR("Object Type")) ;
	m_lServer.setText (TR("Server Name")) ;
	m_lObject.setText (TR("Object Name")) ;

	m_bDelete.setText (TR("Delete")) ;
	m_bCreate.setText (TR("New"   )) ;
	m_bCancel.setText (TR("Cancel")) ;
	m_bOpen  .setText (TR("Open"  )) ;

	QStringList	servers	;
	QListIterator<KBServerInfo> *dIter = dbInfo->getServerIter () ;
	while (dIter->current() != 0)
	{
		servers.append (dIter->current()->serverName()) ;
		++*dIter ;
	}
	delete	dIter ;

	servers.sort () ;

	m_cbType  .insertStringList (allParts) ;
	m_cbServer.insertItem	    (KBLocation::m_pFile) ;
	m_cbServer.insertStringList (servers ) ;

	setLastValue (m_cbType,	  lastType   ) ;
	setLastValue (m_cbServer, lastServer ) ;
	userChange   () ;
	setLastValue (m_cbObject, lastObject ) ;
}

/*  KBQuickDlg								*/
/*  clickDelete	: User clicks delete button				*/
/*  (returns)	: void		:					*/

void	KBQuickDlg::clickDelete ()
{
	done (Delete) ;
}

/*  KBQuickDlg								*/
/*  clickCreate	: User clicks create button				*/
/*  (returns)	: void		:					*/

void	KBQuickDlg::clickCreate ()
{
	done (Create) ;
}

/*  KBQuickDlg								*/
/*  clickCancel	: User clicks cancel button				*/
/*  (returns)	: void		:					*/

void	KBQuickDlg::clickCancel ()
{
	done (Cancelled) ;
}

/*  KBQuickDlg								*/
/*  clickOpen	: User clicks open  button				*/
/*  (returns)	: void		:					*/

void	KBQuickDlg::clickOpen ()
{
	done (Open) ;
}

/*  KBQuickDlg								*/
/*  userChange	: User changes selections				*/
/*  (returns)	: void		:					*/

void	KBQuickDlg::userChange ()
{
	QString		typName	= m_cbType    .currentText () ;
	QString		svrName	= m_cbServer  .currentText () ;
	KBFileList	*fList	= m_fileDict  .find (typName) ;
	KBScriptList	*sList	= m_scriptDict.find (typName) ;

	fprintf
	(	stderr,
		"KBQuickDlg::userChange: typ=[%s] svr=[%s] fl=%p sl=%p\n",
		(cchar *)typName,
		(cchar *)svrName,
		(void  *)fList,
		(void  *)sList
	)	;

	KBServerInfo	*server	= m_dbInfo->findServer (svrName) ;

	m_cbObject.clear () ;
	m_bDelete .setEnabled (false) ;
	m_bCreate .setEnabled (false) ;
	m_bOpen   .setEnabled (false) ;

	if (server == 0)
	{
		fprintf
		(	stderr,
			"KBQuickDlg::userChange: server [%s] not found\n",
			(cchar *)m_cbServer.currentText ()
		)	;
		return	;
	}

	if (fList != 0)
	{
		m_cbObject.insertStringList (fList->getObjectNames (server)) ;
		if (!fList->inherits("KBTableList"))
		{	m_bCreate .setEnabled (true) ;
			m_bDelete .setEnabled (m_cbObject.count() > 0) ;
		}
		m_bOpen   .setEnabled (m_cbObject.count() > 0) ;
	        m_bOpen   .setText    (TR("Open")) ;
		m_bOpen	  .setFocus   () ;
		return	;
	}
	if (sList != 0)
	{
		m_cbObject.insertStringList (sList->getObjectNames (server)) ;
		m_bCreate .setEnabled (true) ;
		m_bDelete .setEnabled (m_cbObject.count() > 0) ;
		m_bOpen   .setEnabled (m_cbObject.count() > 0) ;
	        m_bOpen   .setText    (TR("Open")) ;
		m_bOpen	  .setFocus   () ;
		return	;
	}

	if (typName == TR("Graphics"))
	{
		KBDBDocIter docIter (true) ;
		KBError	    error   ;
		QString	    name    ;
		QString	    stamp   ;

		if (!docIter.init
			(	m_dbInfo,
				svrName,
				"graphic",
				"*",
				error
			))
		{
			error.DISPLAY() ;
			return	;
		}

		while (docIter.getNextDoc (name, stamp))
			m_cbObject.insertItem (name) ;

		m_bCreate .setEnabled (true) ;
		m_bDelete .setEnabled (m_cbObject.count() > 0) ;
		m_bOpen   .setEnabled (m_cbObject.count() > 0) ;
	        m_bOpen   .setText    (TR("Edit")) ;
		m_bOpen	  .setFocus   () ;
		return	;
	}

#if	! __KB_EMBEDDED
	if (typName == TR("Printers"))
	{
		KBDBDocIter docIter ;
		KBError	    error   ;
		QString	    name    ;
		QString	    stamp   ;

		if (!docIter.init
			(	m_dbInfo,
				svrName,
				"print",
				"prn",
				error
			))
		{
			error.DISPLAY() ;
			return	;
		}

		while (docIter.getNextDoc (name, stamp))
			m_cbObject.insertItem (name) ;

		m_bCreate .setEnabled (true) ;
		m_bDelete .setEnabled (m_cbObject.count() > 0) ;
		m_bOpen   .setEnabled (m_cbObject.count() > 0) ;
	        m_bOpen   .setText    (TR("Edit")) ;
		m_bOpen	  .setFocus   () ;
		return	;
	}
#endif

	fprintf
	(	stderr,
		"KBQuickDlg::userChange: type [%s] not found\n",
		(cchar *)m_cbType.currentText ()
	)	;
}


/*  KBQuickDlg								*/
/*  getResults	: Get result values					*/
/*  type	: QSTring &	: Selected object type			*/
/*  server	: QSTring &	: Server result				*/
/*  object	: QSTring &	: Selected bject name			*/
/*  (returns)	: void;		:					*/

void	KBQuickDlg::getResults
	(	QString		&type,
		QString		&server,
		QString		&object
	)
{
	type	= lastType	= m_cbType  .currentText () ;
	server	= lastServer	= m_cbServer.currentText () ;
	object	= lastObject	= m_cbObject.currentText () ;
}
