/***************************************************************************
    file	         : kb_debug.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>


#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_gui.h"
#include	"kb_script.h"
#include	"kb_viewer.h"

#include	"tk_config.h"

#ifndef 	_WIN32
#include	"kb_debug.moc"
#else
#include	"kb_debug.h"
#endif


/*  KBDebug	: 							*/
/*  KBDebug	: Constructor for debugger base class			*/
/*  action	: KToggleAction * : Show/hide action for this window	*/
/*  language	: const QString & : Language				*/
/*  (returns)	: KBDebug	  :					*/

KBDebug::KBDebug
	(	TKToggleAction	*action,
		const QString	&language
	)
	:
	KBasePart	(0, 0, WDestructiveClose|WStyle_NormalBorder),
	m_action	(action),
	m_language	(language)
{
	KBError	error	;

	m_gui	    = 0	;
	m_topWidget = 0	;
	m_scrIface  = 0	;
}

/*  KBDebug	: 							*/
/*  ~KBDebug	: Destructor for simple script editor			*/
/*  (returns)	:		:					*/

KBDebug::~KBDebug ()
{
	DELOBJ	(m_gui) ;
}

/*  KBDebug	: 							*/
/*  getConfig	: Get configuration object for this debugger		*/
/*  (returns)	: TKConfig *	: Configuration object (group set)	*/

TKConfig*KBDebug::getConfig ()
{
	TKConfig *config = TKConfig::getConfig () ;
	config->setGroup (QString("Debug Options/%1").arg(m_language)) ;
	return	config	;
}

/*  KBDebug								*/
/*  hide	: Trap window hide					*/
/*  (returns)	: void		:					*/

void	KBDebug::hide ()
{
	KBasePart::hide    () ;
	m_action->setChecked (false) ;
}

/*  KBDebug								*/
/*  queryClose	: Check whether OK to close				*/
/*  (returns)	: bool		: OK					*/

bool	KBDebug::queryClose ()
{
	m_size	= m_partWidget->size() ;
	m_action->setChecked (false)   ;
	return	true	;
}

