/***************************************************************************
    file	         : kb_part.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  __KB_MDICHILD_H
#define  __KB_MDICHILD_H

#include	<qguardedptr.h>

#include	"kb_classes.h"
#include	"kb_gui.h"
#include	"kb_partwidget.h"

#include	"tk_part.h"

#include 	"libapp_exports.h"


class	KBaseApp	;
class	KBasePart	;
class	KBFormViewer	;
class	KBReportViewer	;
class	KBDBaseViewer	;
class	KBTableViewer	;
class	KBQueryViewer	;
class	KBTextLog	;
class	KBEditor	;
class	KBPartWidget	;
class	KBObjBase	;
class	KBSDIMainWindow	;
struct	GUIElement	;



#if	__KB_KDE
#define	ACTION		KAction
#endif
#if	__KB_TKC
#define	ACTION		TKAction
#endif

/*  KBasePart								*/
/*  ----------								*/
/*  The KBasePart class is used as a base class for all windows which	*/
/*  are children of the MDI workspace.					*/

class	LIBAPP_API KBasePart : public TKPart
{
	Q_OBJECT

	KBaseGUI			*m_currentGUI	;
	GUIElement			*m_localGUISpec	;
	bool				m_modal		;

protected :

	QGuardedPtr<KBObjBase>		m_objBase	;
	QGuardedPtr<KBSDIMainWindow>	m_mainWin	;
	QGuardedPtr<KBPartWidget>	m_partWidget	;

	QWidget				*m_topWidget	;
	QWidget				*m_embed	;

	bool		openFile	() { return false 	; }
	bool		saveFile	() { return false 	; }

	void		setGUI	 	(KBaseGUI   *) ;
	
public	:
	
		 KBasePart (KBObjBase  *, QWidget *, int flags, bool = false) ;
	virtual	~KBasePart () ;

	virtual	KBFormViewer	*isFormViewer	() { return 0 ; }
	virtual	KBReportViewer	*isReportViewer	() { return 0 ; }
	virtual	KBQueryViewer	*isQueryViewer 	() { return 0 ; }
	virtual	KBTableViewer	*isTableViewer 	() { return 0 ; }
	virtual	KBDBaseViewer	*isDBaseViewer 	() { return 0 ; }
	virtual	KBEditor	*isEditor      	() { return 0 ; }

	virtual	void		resizeEvent	(QResizeEvent *) ;
	virtual	void		show		() ;
	virtual	void		hide		() ;

	virtual	bool		queryClose	() { return true         ; }
	inline	QWidget		*getTopWidget	() { return m_topWidget  ; }
	inline	KBPartWidget	*getPartWidget	() { return m_partWidget ; }
	KBaseGUI		*getCurrentGUI	() { return m_currentGUI ; }

	virtual	cchar		*getChanged	(bool)
	{
		return	0      ;
	}
	inline	GUIElement	*getLocalGUISpec ()
	{
		return	m_localGUISpec	;
	}
	inline	void		setLocalGUISpec
		(	GUIElement	*spec
		)
	{
		m_localGUISpec	= spec	;
	}
	inline	KBSDIMainWindow	*getMainWindow	()
	{
		return	m_mainWin	;
	}
	inline	bool		isModal ()
	{
		return	m_modal	;
	}

	ACTION 			*action	      	(const char	   *) const ;
	virtual	ACTION	 	*action	      	(const QDomElement &) const ;

	void			guiEnable   	(cchar    *, bool) ;
	void			guiEnable   	(KB::GGroup, bool) ;

public	slots	:

	void			slotClose	() ;
}	;

#endif // __KB_MDICHILD_H
