/***************************************************************************
    file	         : kb_callback.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_CALLBACK_H
#define	__KB_CALLBACK_H

#include 	<qstring.h>
#include 	<qwidget.h>
#include 	<qdict.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include 	"kb_location.h"

#include 	"libcommon_exports.h"

class	TKAction	;
class	KBasePart	;


class	LIBCOMMON_API	KBCallback
{
public	:

	virtual	KB::ShowRC	openObject 	(KBLocation &, KB::ShowAs, QDict<QString> &, KBError &, const KBValue & = KBValue(), QDict<QString> * = 0) ;
	virtual	bool		newObject  	(KBLocation &, KBError &) ;
	virtual	bool		editScript 	(KBLocation &, const QString  &, const QString &, uint, KBError &) ;
	virtual	KBObjBase	*showingObj	(KBLocation &) ;
	virtual	KBNode		*objectNode	(KBLocation &) ;

	virtual	void		logQuery	(const QString &, const QString &, bool, uint  = 0, const KBValue * = 0) ;
	virtual	void		*logEvent	(const QString &, const QString &, const QString &, const QString &, uint = 0, const KBValue * = 0) ;
	virtual	void		logEventResult	(const KBValue &, bool, void *) ;
	virtual	void		logScript	(const QString &, bool) ;

	virtual	TKAction	*globalAction	(const QString &) ;
	virtual	bool		useMDIMode	() ;

	virtual	void		addPart		(KBasePart *) ;
	virtual	void		dropPart	(KBasePart *) ;
	virtual	void		alterPart	(KBasePart *) ;

	virtual	bool		displayError	(const KBError &, const QString &, cchar *, uint) ;
}	;

#endif	// __KB_CALLBACK_H
