/***************************************************************************
    file	         : kb_dbinfo.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_DBINFO_H
#define	_KB_DBINFO_H

#include	<qdict.h>
#include	<qdir.h>
#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_serverinfo.h"

#include	"libcommon_exports.h"


/*  KBDBInfo								*/
/*  ------								*/
/*  This class contains all root information for a particular KBase	*/
/*  database.								*/

class	LIBCOMMON_API	KBDBInfo
{
protected :

	QString			m_dbName	; /* Database file name	*/
	QString			m_dbPath	; /* Database path	*/
	QString			m_dbExtn	; /* Database extension	*/

	QDict<KBServerInfo>	m_servers	; /* Servers		*/
	KBServerInfo		*m_files	; /* Notional file server	*/

	QList<KBServerInfo>	m_svrList	; /* List of servers	*/

	uint			m_version	; /* Rekall version	*/
	bool			m_wasBSF	; /* Data base bar-sep	*/


	void			loadDomFormat	(const QString &) ;
	void			loadBSFFormat	(const QString &) ;

	virtual	KBServerInfo	*newServerInfo	() ;
	virtual	KBServerInfo	*newServerInfo	(const QString	   &) ;
	virtual	KBServerInfo	*newServerInfo	(const QDomElement &) ;

public	:

	KBDBInfo (const QString &)	;
	virtual	 ~KBDBInfo ()		;

	void	init			(bool)	;
	void	remove			(KBServerInfo  *, bool = true) ;
	void	insert			(KBServerInfo  *) ;
	bool	save			(const QString &) ;

	KBServerInfo	*findServer	(const QString &) ;
	KBTableInfoSet	*findTableInfoSet
					(const QString &) ;
	KBTableInfo	*findTableInfo	(const QString &, const QString &) ;

	QListIterator<KBServerInfo>	*getServerIter	() ;

	inline	KBServerInfo	*getFilesServer ()
	{
		return	m_files	;
	}
	inline	bool	save 	()
	{
		return	save	(m_dbName) ;
	}
	inline	uint	version	()
	{
		return	m_version ;
	}
	inline	void	setVersion
		(	uint	version
		)
	{
		m_version = version ;
	}

	inline	const QString	&getDBName () { return	m_dbName ; }
	inline	const QString	&getDBPath () { return	m_dbPath ; }
	inline	const QString	&getDBExtn () { return	m_dbExtn ; }
}	;

#endif	// _KB_DBINFO_H
