/***************************************************************************
    file	         : kb_dblink.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_DBLINK_H
#define	_KB_DBLINK_H


#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_serverinfo.h"

#include	"libcommon_exports.h"


/*  KBDBLink								*/
/*  --------								*/
/*  The KBDBLink class is really just a wrapper for KBServer server	*/
/*  connection objects. Its primary function is to provide an object	*/
/*  where the destructor can drop the (logical) connection.		*/

class LIBCOMMON_API	KBDBLink
{
	KBServerInfo	*m_svInfo	;
	KBError		m_lError	;
	bool		m_disabled	;

	uint		m_nOp		;
	const cchar	**m_opMap	;

	bool		checkLinked	(int) ;

public	:

	KBDBLink	() ;
       ~KBDBLink	() ;

	bool		connect		(const KBLocation &, const QString &, bool = true) ;
	bool		connect		(KBDBInfo	  *, const QString &, bool = true) ;
	void		disconnect	() ;

	KBSQLSelect	*qrySelect	(bool, const QString &, bool = false) ;
	KBSQLUpdate	*qryUpdate	(bool, const QString &, const QString &) ;
	KBSQLInsert	*qryInsert	(bool, const QString &, const QString &) ;
	KBSQLDelete	*qryDelete	(bool, const QString &, const QString &) ;
	KBSQLCursor	*qryCursor	(bool, const QString &, const QString &) ;

	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect ** = 0) ;
	bool		transaction	(KBServer::Transaction, void **) ;

	bool		getRowIdent	(const QString  &) ;

	bool		tableExists	(const QString  &, bool &) ;
	bool		listTables	(KBTableDetailsList	&, uint = KB::IsTable|KB::IsView) ;
	bool		listFields	(KBTableSpec   		&) ;

	bool		createTable	(KBTableSpec    &, bool) ;
	bool		renameTable	(const QString  &, const QString &, bool) ;
	bool		dropTable	(const QString  &, bool) ;

	bool		viewExists	(const QString  &, bool  &) ;
	bool		createView	(KBTableSpec    &) ;
	bool		renameView	(const QString  &, const QString &) ;
	bool		dropView	(const QString  &) ;

	bool		sequenceExists	(const QString  &, bool  &) ;
	bool		descSequence	(KBSequenceSpec &) ;
	bool		createSequence	(KBSequenceSpec &) ;
	bool		renameSequence	(const QString  &, const QString &) ;
	bool		dropSequence	(const QString  &) ;

	bool		copyLink	(KBDBLink       &, bool) ;

	QString		placeHolder	(uint) ;
	QString		listTypes	() ;
	QString		getDBType	() ;
	bool		keepsCase	() ;
	QString		fixCase		(const QString &) ;
	void		flushTableCache	() ;

	QString		rekallPrefix	(const QString & = QString::null) ;
	QString		mapExpression	(const QString &) ;

	cchar		*mapOperator	(KBServer::Operator, cchar *) ;

	QString		objectTableName	() ;
	QString		designTableName	() ;

	bool		hasObjectTable	() ;
	bool		hasDesignDict	() ;

	KBServer	*server		() ;

	inline bool		disabled     ()	{ return m_disabled	; }
	inline const KBError	&lastError   () { return m_lError	; }

	/* The following two methods are for use by the python code	*/
	/* which is associated with the table data view.		*/
	uint	getColumnWidth	(const QString &, const QString &) ;
	void	setColumnWidth	(const QString &, const QString &, uint) ;
}	;

#endif	// _KB_DBLINK_H
