/***************************************************************************
    file	         : kb_libloader_kde.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


/*  This file contains the library loader code for KDE builds of	*/
/*  Rekall. By preference it would be in libkbase_kde, but in order	*/
/*  that libkbase_common does not have any depend on any other Rekall	*/
/*  libraries (so that the drivers can be used outside of Rekall) we	*/
/*  have to put it here.						*/

#if		__KB_KDE

#include	"kb_libloader_kde.h"


/*  KBLibLoader								*/
/*  self	: Instantiate the library loader			*/
/*  (returns)	: KBLibLoader *	: Loader object				*/

KBLibLoader
	*KBLibLoader::self ()
{
	static	KBLibLoader	*loader	;
	if (loader == 0) loader = new KBLibLoader ;
	return	loader	;
}

/*  KBLibLoader								*/
/*  getLibrary	: Load a library					*/
/*  libname	: const char *	: Library name				*/
/*  (returns)	: KBLibrary *	: Library object or null on error	*/

KBLibrary
	*KBLibLoader::getLibrary
	(	const char	*libname
	)
{
	KLibrary *lib	= KLibLoader::library (libname) ;
	return	 lib == 0 ? 0 : new KBLibrary (lib)	;
}

/*  KBLibLoader								*/
/*  getGlobalLibrary							*/
/*		: Load a library with global symbol access		*/
/*  libname	: const char *	: Library name				*/
/*  (returns)	: KBLibrary *	: Library object or null on error	*/


KBLibrary
	*KBLibLoader::getGlobalLibrary
	(	const char	*libname
	)
{
	KLibrary *lib	= KLibLoader::globalLibrary (libname) ;
	return	 lib == 0 ? 0 : new KBLibrary (lib)	;
}


/*  ------------------------------------------------------------------  */

KBPartFactory::~KBPartFactory ()
{
}

QObject	*KBPartFactory::create
	(	QObject *		,
		const char *		,
		const char *		,
		const QStringList &
	)
{
	return	0 ;
}

KParts::Part
	*KBPartFactory::createPartObject
	(	QWidget *		,
		const char *		,
		QObject *		,
		const char *		,
		const char *		,
		const QStringList &	
	)
{
	return	0	;
}

const char
	*KBPartFactory::ident ()
{
	return	0 ;
}


KBFactory::~KBFactory ()
{
}

QObject	*KBFactory::create
	(	QObject *		,
		const char *		,
		const char *		,
		const QStringList &
	)
{
	return	0 ;
}

QObject	*KBFactory::createObject
	(	QObject *		,
		const char *		,
		const char *		,
		const QStringList &
	)
{
	return	0 ;
}

const char
	*KBFactory::ident ()
{
	return	0 ;
}

#endif	// __KB_KDE
