/***************************************************************************
    file	         : kb_type.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_TYPE_H
#define	_KB_TYPE_H

#include	<qstring.h>
#include	<qtextcodec.h>

#include	"kb_shared.h"
#include	"libcommon_exports.h"


/*  KBType								*/
/*  ------								*/
/*  This class is used to encapsulate type information relating to the	*/
/*  underlying database, sprecifically a KBase internal type, the real	*/
/*  database type, and whether the value may be null.			*/

struct	KBDataArray	;

class	LIBCOMMON_API	KBType	: public KBShared
{
protected :

	cchar		*m_id	;	/* Driver ID			*/
	KB::IType	m_iType	;	/* Internal type		*/
	uint		m_length;	/* Underlying database length	*/
	uint		m_prec	;	/* Precision where applicable	*/
	bool		m_nullOK;	/* Value may be null		*/

public	:

	KBType	(cchar *, KB::IType, uint, uint, bool) ;
	KBType	(cchar *, KB::IType, uint, uint, bool, bool) ;
       ~KBType	()		;

	virtual	bool		isValid
				(	const QString	&,
					KBError		&,
					const QString   & = QString::null
				)	;

	virtual	void		getQueryText	(KBDataArray *, KBShared *, KBDataBuffer &, QTextCodec * = 0) ;
	virtual	QString		getQueryText	(KBDataArray *, KBShared *) ;
	virtual	void		escapeText	(KBDataArray *,		    KBDataBuffer &) ;
	virtual	void		escapeText	(QCString    &,		    KBDataBuffer &) ;

	inline	cchar		*getID		() { return m_id     ; }
	inline	KB::IType	getIType	() { return m_iType  ; }
	inline	uint		getLength	() { return m_length ; }
	inline	uint		getPrecision	() { return m_prec   ; }

	virtual	QString		getDescrip	(bool = false)	;
	static	KBType		*typeToType	(KB::IType)	;

	friend	class		KBValue ;
}	;


/*  KBStaticType							*/
/*  ------------							*/
/*  This class is used for static instances of KBType, so that we can	*/
/*  safely call ::ref() and ::deref().					*/

class	LIBCOMMON_API	KBStaticType : public KBType
{
public	:
	KBStaticType	(KB::IType, uint, uint, bool) ;
}	;


extern LIBCOMMON_API	KBStaticType	_kbUnknown	;
extern LIBCOMMON_API	KBStaticType	_kbRaw	 	;
extern LIBCOMMON_API	KBStaticType	_kbFixed 	;
extern LIBCOMMON_API	KBStaticType	_kbFloat	;
extern LIBCOMMON_API	KBStaticType	_kbDate		;
extern LIBCOMMON_API	KBStaticType	_kbTime		;
extern LIBCOMMON_API	KBStaticType	_kbDateTime	;
extern LIBCOMMON_API	KBStaticType	_kbString	;
extern LIBCOMMON_API	KBStaticType	_kbBinary	;
extern LIBCOMMON_API	KBStaticType	_kbBool		;

#endif	// _KB_TYPE_H
