/***************************************************************************
    file	         : ellib1.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<string.h>
#include	<setjmp.h>
#include	<ctype.h>
#include	<std.h>

#ifdef		_WIN32
#include	<io.h>
#else
#include	<unistd.h>
#endif

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"


EXTERN	char	*tagToStr (int, char *) ;
EXTERN	VALUE	el_ioopen  (VALUE *) ;

LVAR	VALUE	numval	;


LFUNC	VALUE	print
	(	VALUE	*argv
	)
{
	printf ("%s", argv[0].val.str->text) ;
	return numval	;
}


/*L el_ntos	: Convert number to string				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: String				*/

LFUNC	VALUE	el_ntos
	(	VALUE	*argv
	)
{
	char	tmp[32]	;

	switch (argv[0].tag->tag)
	{	case V_NUM : sprintf  (tmp, "%d", argv[0].val.num) ; break ;
		case V_DBL : sprintf  (tmp, "%f", argv[0].val.dbl) ; break ;
		default	   : el_error ("Unexpected %s in ntos", argv[0].tag->ident) ;
	}
	return	VALUE(new STRING (tmp)) ;
}

/*L el_istype	: General type test					*/
/*  argv	: VALUE		: Arguments				*/
/*  (returns)	: VALUE		: Success				*/

LFUNC	VALUE	el_istype
	(	VALUE	*argv
	)
{
	numval.val.num	= argv[0].tag->tag == argv[1].val.num ;
	return	numval	;
}

/*L el_load	: Load a file						*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: 0 -> not loaded, 1 -> loaded		*/

LFUNC	VALUE	el_load
	(	VALUE	*argv
	)
{
	numval.val.num	= el_loadfile (argv[0].val.str->text) ;
	return	numval	;
}

/*L el_getenv	: Get environment value					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

LFUNC	VALUE	el_getenv
	(	VALUE	*argv
	)
{
	char	*env	= (char *) getenv (argv[0].val.str->text) ;
	if (env == NULL) return VALUE (0) ;
	return	VALUE (new STRING (env)) ;
}

/*L el_ctos	: Convect character to string				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: Result				*/

LFUNC	VALUE	el_ctos
	(	VALUE	*argv
	)
{
	char	str[2]	;
	str[0]	= argv[0].val.num ;
	str[1]	= 0	;
	return	VALUE (new STRING (str)) ;
}

/*L el_errorif	: Invoke error routine					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		: (Never returns)			*/

LFUNC	VALUE	el_errorif
	(	VALUE	*argv
	)
{
	el_error (argv[0].val.str->text) ;
	return	numval	;
}


LIBEL32_API
	MC	el_lib1sp [] =
{
	{	"open",		{ &tagSTR, &tagSTR,		0 },	el_ioopen	},

	{	"ctos",		{ &tagNUM,			0 },	el_ctos		},
	{	"error",	{ &tagSTR, &tagNUM,		0 },	el_errorif	},
	{	"getenv",	{ &tagSTR,			0 },	el_getenv	},
	{	"istype",	{ &tagANY, &tagNUM,		0 },	el_istype	},
	{	"load",		{ &tagSTR,			0 },	el_load		},
	{	"ntos",		{ &tagANY,			0 },	el_ntos		},
	{	"print",	{ &tagSTR,			0 },	print		},
	{	NULL,		{				0 },	NULL		}
}	;

/*G el_initlib	: Initialise library					*/
/*  mptr	: MC *		: Library specification vector		*/
/*  (returns)	: void		:					*/

GFUNC	void	el_initlib
	(	MC	*mptr
	)
{
	ITEM	*item	;

	for ( ; mptr->name != NULL ; mptr += 1)
	{	item			= _el_insname (mptr->name ,1) ;	
		item->value.tag		= &tagFN  ;
		item->value.val.mc	= mptr	  ;
	}
}
