/***************************************************************************
    file	         : escstr.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<string.h>
#include	<setjmp.h>
#include	<ctype.h>
#include	<std.h>

#include	"eli.h"

typedef	struct
{	unsigned int	codes[4];
	char		name [6];
}	KEYCODE	;

#define		NAME(x)	, x
#define		INCFN

#define	WLEN	8

/*L numesc	: Handle numerical escape				*/
/*  sptr	: char *	: Escape string pointer			*/
/*  lvsptr	: char **	: Return location for new pointer	*/
/*  (returns)	: int		: Numerical value			*/

LFUNC	int	numesc
	(	const char	*sptr,
		const char	**lvsptr
	)
{
	int	radix	;
	int	len	;
	int	value	;
	int	digit	;

	if (*sptr == '0')
		if ((sptr[1] == 'x') || (sptr[1] == 'X'))
			radix	= 16, len = 2, sptr += 2 ;
		else	radix	= 8,  len = 3, sptr += 1 ;
	else	radix = 10, len = 4 ;

	for (value = 0 ; *sptr && (len > 0) ; sptr += 1, len -= 1)
	{
		if	(('0' <= *sptr) && (*sptr <= '9')) digit = *sptr - '0' ;
		else if (('a' <= *sptr) && (*sptr <= 'f')) digit = *sptr - 'a' + 10 ;
		else if (('A' <= *sptr) && (*sptr <= 'F')) digit = *sptr - 'A' + 10 ;
		else					   digit = 16 ;

		if (digit >= radix) break ;

		value	= value * radix + digit ;
	}

	*lvsptr	= sptr	;
	return	value	;
}

/*G _el_escape	: Process escape sequence				*/
/*  sptr	: char *	: Pointer just after escape		*/
/*  tptr	: char *	: Location for result			*/
/*  ext		: int		: Handle extended escapes		*/
/*  (returns)	: char *	: Pointer after escape sequence		*/

GFUNC	const char *_el_escape
	(	const char	*sptr,
		char		*tptr,
		int		
	)
{
	/* Those recognised are : \n \r \b \t \e	: characters	*/
	/*			: \0			: octal		*/
	/*			: \0x			: hexadecimal	*/
	/*			: \^			: control	*/
	/* In addition, if "ext" is true then escapes of the form	*/
	/* \{...} are recognised.					*/

	switch ((int)*sptr)
	{	case 'n' : *tptr = '\n' ; sptr += 1 ; break ;
		case 'r' : *tptr = '\r' ; sptr += 1 ; break ;
		case 'b' : *tptr = '\b' ; sptr += 1 ; break ;
		case 't' : *tptr = '\t' ; sptr += 1 ; break ;
		case 'e' : *tptr = 0033 ; sptr += 1 ; break ;
		case '^' :
			sptr += 1 ;
			if	(isupper (*sptr)) *tptr = *sptr++ - 'A' + 1 ;
			else if (islower (*sptr)) *tptr = *sptr++ - 'a' + 1 ;
			else			  *tptr	= *sptr++ ;
			break	;

#if	0
		case '{' :
			/* Escapes like \{...} are recognised if the	*/
			/* ext parameter is set.			*/
			if (ext)
			{	*tptr	= extesc (&sptr[1], &sptr) ;
				break	;
			}
#endif

		default  :
			if (isdigit (*sptr))
			{	*tptr	= numesc (sptr, &sptr) ;
				break ;
			}
			*tptr	= *sptr++ ;
			break	;
	}

	return	sptr	;
}
