/***************************************************************************
    file	         : load.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#define		MAINDEF
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<std.h>
#include	<string.h>
#include	<fcntl.h>
#include	<setjmp.h>
#include	<except.h>

#ifdef		_WIN32
#include	<io.h>
#else
#include	<unistd.h>
#endif

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"
#include	"code.h"

LVAR	int	fid		    ;
LVAR	char	*codebuf	    ;
LVAR	int	codelen		    ;
LVAR	int	*mapstr		    ;	/* String mapping table		*/
LVAR	int	*maptab		    ;	/* Item mapping table		*/
LVAR	int	nnames		    ;	/* Number of names in file	*/
LVAR	int	nstrs		    ;	/* Number of strings in file	*/
LVAR	char	loader[] = "loader" ;	/* Used several times ...	*/

#define	HSIZE	64			/* Hash table size		*/
#define	HMASK	(HSIZE-1)		/* Hashing mask			*/
					/* Hash table for names/strings	*/
LVAR	int	hashtab[HSIZE]	=
{	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1,
	-1,	-1,	-1,	-1,	-1,	-1,	-1,	-1
}	;


extern	METHSET	el_strMethSet	;
extern	METHSET	el_vecMethSet	;
extern	METHSET	el_hashMethSet	;
extern	METHSET	el_ioMethSet	;


GVAR	ELTAG	tagANY	= { V_ANY,	0,		0,		"any type"		} ;
GVAR	ELTAG	tagUNDEF= { V_UNDEF,	0,		0,		"undefined"		} ;
GVAR	ELTAG	tagNUM	= { V_NUM,	0,		0,		"number"		} ;
GVAR	ELTAG	tagDBL	= { V_DBL,	0,		0,		"double"		} ;
GVAR	ELTAG	tagSTR	= { V_STR,	TF_SHARED,	&el_strMethSet,	"string"		} ;
GVAR	ELTAG	tagELC	= { V_ELC,	TF_SHARED,	0,		"elc function"		} ;
GVAR	ELTAG	tagPUB	= { V_PUB,	TF_SHARED,	0,		"public function"	} ;
GVAR	ELTAG	tagFN	= { V_FN,	0,		0,		"library routine"	} ;
GVAR	ELTAG	tagVEC	= { V_VEC,	TF_SHARED,	&el_vecMethSet,	"vector"		} ;
GVAR	ELTAG	tagHASH	= { V_HASH,	TF_SHARED,	&el_hashMethSet,"hash table"		} ;
GVAR	ELTAG	tagPTR	= { V_PTR,	0,		0,		"pointer"		} ;
GVAR	ELTAG	tagIO	= { V_IO,	TF_SHARED,	&el_ioMethSet,	"I/O object"		} ;
GVAR	ELTAG	tagERR	= { V_ERR,	0,		0,		"error"			} ;


/*  _el_read	: Read from code source					*/
/*  buf		: void *	: Buffer				*/
/*  len		: int		: Required length			*/
/*  (returns)	: int		: Length read				*/

LFUNC	int	_el_read
	(	void	*buf,
		int	len
	)
{
	if (fid >= 0)
		return	read (fid, buf, len) ;

	if (len > codelen)
		len	= codelen ;

	memcpy	(buf, codebuf, len) ;
	codebuf += len ;
	codelen -= len ;

	return	len ;
}

/*G el_allocate	: Allocate space checking for errors			*/
/*  size	: int		: Space required in bytes		*/
/*  where	: char *	: Caller				*/
/*  (returns)	: void *	: Pointer at allocated space		*/

GFUNC	void	*el_allocate
	(	int		size,
		const char	*where
	)
{
	void	*p	= NULL ;

	if (size > 0)
		if ((p = (void *) calloc (1, size)) == NULL)
			el_error ("EL: out of memory in %s", where) ;

	return	p ;

}

/*L hashval	: Hash string						*/
/*  str		: char *	: String				*/
/*  (returns)	: int		: Hash value				*/

GFUNC	int	hashval
	(	const char	*str
	)
{
	int	hval	;
	for (hval = 0 ; *str ; str += 1) hval = hval * 13 + *str ;
	return	hval & HMASK ;
}

/*G _el_insname	: Lookup and insert name/string into hash table		*/
/*  str		: char *	: String in question			*/
/*  stat	: int		: TRUE if string is static		*/
/*  (returns)	: ITEM *	: Entry in hash (and master) table	*/

GFUNC	ITEM	*_el_insname
	(	const char	*str,
		int		stat
	)
{
	int	hval	= hashval (str) ;
	int	hidx	;
	char	*text	;
	ITEM	*item	;

#if	0
	fprintf	(stderr, "===>[%s]\n", str) ;
#endif
	/* Scan the master table to see if the string is already	*/
	/* present. If it is then return a pointer at the entry.	*/
	for (hidx = hashtab[hval] ; hidx >= 0 ; hidx = _el_master[hidx].hlink)
		if (strcmp (str, _el_master[hidx].name) == 0)
			return	&_el_master[hidx] ;

	if (_el_mcnt >= ARBITS + 1) el_error ("EL master name table full") ;

	/* Not present so it needs to be inserted. If the string is not	*/
	/* static then allocate space and make a copy of it.		*/
	if (!stat)
	{	text	= (char *) el_allocate (strlen (str) + 1, loader) ;
		strcpy	(text, str) ;
		str	= text	    ;
	}

	/* The name goes at the top of the master table, and is chained	*/
	/* into the hash table. It is initialised at this point as	*/
	/* undefined.							*/
	item		= &_el_master[_el_mcnt] ;
	item->hlink	= hashtab[hval]		;
	item->name	= str			;
	item->value.tag	= &tagUNDEF		;
	hashtab[hval]	= _el_mcnt++		;

	return	item	;
}

/*L readitems	: Read list of items from file				*/
/*  cnt		: int		: Number of items			*/
/*  mapper	: int *		: Mapping table				*/
/*  (returns)	: void		:					*/

LFUNC	void	readitems
	(	int	cnt,
		int	*mapper
	)
{
	int	idx	;

	for (idx = 0 ; idx < cnt ; idx += 1)
	{
		char	name[128];
		int	head[2]	 ;
		int	type	 ;
		int	len	 ;

		/* Read the type and length words and strip off the	*/
		/* opcode bits. Then allocate space for the text and	*/
		/* read this in as well.				*/
		_el_read (head, sizeof(head)) ;
		type = head[0] & ARBITS ;
		len  = head[1] & ARBITS ;

		_el_read (name, len)   ;

		/* Now store the string in the master table and save	*/
		/* the entry number for use when the code is relocated.	*/
		mapper[idx] = _el_insname (name, 0) - _el_master ;

#if	0
		fprintf	(stderr, "===>[%s]\n", name) ;
#endif
	}
}

/*L loaditems	: Load name and string items from tables in file	*/
/*  (returns)	: void		:					*/

LFUNC	void	loaditems ()
{
	/* Read in the words containing the numbers of names and of	*/
	/* strings, and strip off the opcode bits.			*/
	_el_read (&nnames, sizeof(int)) ; nnames &= ARBITS ;
	_el_read (&nstrs,  sizeof(int)) ; nstrs  &= ARBITS ;

	/* Allocate space for the string table, and for the name,	*/
	/* mapping table. Then loop reading each name and each string;	*/
	/* this is handled via the common "readitems" routine which is	*/
	/* passed the appropriate mapping array.			*/
	mapstr	= (int *) el_allocate (nstrs  * sizeof(int), loader) ;
	maptab	= (int *) el_allocate (nnames * sizeof(int), loader) ;

	readitems (nnames, maptab) ;
	readitems (nstrs,  mapstr) ;
}

/*L fixup	: Fix up name and string references in code		*/
/*  code	: int *		: Code buffer				*/
/*  len		: int		: Code length				*/
/*  (returns)	: void		:					*/

LFUNC	void	fixup
	(	int	*code,
		int	len
	)
{
	while (len > 0)
	{
		int	op	= (*code & OPBITS) >> OPSHIFT ;
		int	arg	= (*code & ARBITS) ;

		if (arg == ARBITS)
		{	arg	 = *++code ;
			len	-= 1	   ;
		}

		switch (op)
		{
			case C_LOUT	:
			case C_SOUT	:
			case C_SOUTP	:
				/* Fix references to the master table.	*/
				*code	= (*code & OPBITS) | maptab[arg] ;
				break	;

			case C_LSTR	:
				/* The load string instruction must be	*/
				/* fixed for the string table.		*/
				*code	= (*code & OPBITS) | mapstr[arg] ;
				break	;

			case C_AT	:
				*code	= (*code & 0xfffff000) | mapstr[*code & 0x0fff] ;
				break	;
		}

		len	-= 1 ;
		code	+= 1 ;

	}
}

/*L loadcode	: Load code from opened file				*/
/*  (returns)	: void		:					*/

LFUNC	void	loadcode ()
{
	int	index		;	/* For function module index	*/
	int	length		;	/* For function length		*/
//	uint	posn		;	/* Code position in buffer	*/
	ITEM	*item		;	/* For master table slot	*/
//	int	*buff		;	/* Read buffer			*/
	ELF	*elf		;	/* EL fuction block		*/
	ELTAG	*type		;	/* Actual EL type		*/

	while (_el_read (&index, sizeof(int)) == sizeof(int))
	{
		/* The function will be marked as either a public or a	*/
		/* normal ELC routine according to the value just read.	*/
		type	= (index & OPBITS) == (C_PDEF << OPSHIFT) ? &tagPUB : &tagELC ;

		/* Read the length word, and then mask to get the	*/
		/* index and length. Locate the correct slot in the	*/
		/* master table, and allocate space in the code buffer.	*/
		if (_el_read (&length, sizeof(int)) != sizeof(int))
		{	fprintf	(stderr, "load: function length missing\n") ;
			exit	(1) ;
		}

		index  &= ARBITS ;
		length &= ARBITS ;
		item	= &_el_master[maptab[index]]   ;

		elf	= new ELF (item->name, length) ;

		/* Allocate a new buffer and read the function code	*/
		/* into it, from where it can then be copied into the	*/
		/* code buffer. The use count is initialised to one and	*/
		/* the name noted.					*/
		length *= sizeof(int) ;

		if (_el_read (elf->code, length) != length)
		{	fprintf	(stderr, "load: truncated function\n") ;
			exit	(1) ;
		}


		/* If there is existing code then it is freed. The new	*/
		/* code is stored and references then fixed up.		*/
		fixup	   (elf->code, length / sizeof(int)) ;

		item->value = VALUE (elf, type) ;
	}
}

/*  el_loadprog	: Load program						*/
/*  (returns)	: bool		: Success				*/

LFUNC	int	el_loadprog ()
{
	unsigned long	magic		;

	/* Check for the magic marker. Don't bother checking that the	*/
	/* read works since if it fails then the magic code will not	*/
	/* be checked. If it is wrong then close the file and return.	*/
	_el_read (&magic, sizeof(long)) ;

	if (magic != MAGIC)
	{	close	(fid) ;
		return	0     ;
	}

	TRAP
	{	/* If an error occurred, unlock the code buffer, close	*/
		/* the file, and return failure.			*/
		close	    (fid) ;
		return	0 ;
	}
	WITHIN
	{
		loaditems () ;		/* Load name and string tables	*/
		loadcode  () ;		/* Load function code		*/
		close	  (fid) ;	/* File now all read		*/

		/* The index mapping tables are freed as these are no	*/
		/* longer needed.					*/
		free	    ((char *)maptab) ;
		free	    ((char *)mapstr) ;
	}
	ENDTRAP

	/* Now see if the start function was defined. If it was then	*/
	/* it is executed. Note that start cannot be public!		*/
	if (_el_master[0].value.tag == &tagELC)
	{
		VALUE	*stos	= _el_tos		;
		VALUE	func	= _el_master[0].value	;

		_el_master[0].value = 0 ;

		TRAP
		{	/* On an error, pop the stack back to its old	*/
			/* state and unlock the code buffer.		*/
			el_popstk   (_el_tos - stos, "start") ;
			return	0 ;
		}
		WITHIN
		{	/* The start routine takes no arguments so	*/
			/* stack a zero before executing the start	*/
			/* function. On return free the result and the	*/
			/* routine itself.				*/
			PUSH 	(0) ;
			_el_execute (func) ;
		}
		ENDTRAP
	}

	return 1 ;
}

/*G el_loadfile	: Load code from named file				*/
/*  file	: char *	: Name of file				*/
/*  (returns)	: int		: Non-zero on success			*/

GFUNC	int	el_loadfile
	(	const char	*file
	)
{

	/* Open the file. First, expand locate the file amongst the	*/
	/* possible places in which it might exist. Then, provided that	*/
	/* it is found, attempt to open it.				*/
	char	fname[256]	;
	if (!el_findfile (file, "elc", fname))	return 0 ;
	if ((fid = open (fname, O_RDONLY)) < 0) return 0 ;

	codebuf	= 0 ;
	codelen = 0 ;

	int rc = el_loadprog () ;
	close (fid) ;
	return	rc  ;
}

/*G el_loadtext	: Load code from buffer					*/
/*  buf		: CBUFF *	: Code					*/
/*  (returns)	: int		: Non-zero on success			*/

GFUNC	int	el_loadtext
	(	CBUFF	*buf
	)
{
	codebuf	= buf->code ;
	codelen	= buf->len  ;
	fid	= -1	    ;

	return	el_loadprog () ;
}

/*G el_ffunc	: Look for function by name in the master table		*/
/*  name	: char *	: Required name				*/
/*  (returns)	: int		: Index or negative if not found	*/

GFUNC	int	el_ffunc
	(	const char	*name
	)
{
	ITEM	*item	= _el_insname (name, 0) ;

	/* If the name refers to a public EL function then return the	*/
	/* index. A negative value repors an error.			*/
	return	item->value.tag == &tagPUB ? item - _el_master : -1 ;
}

/*G el_funcn	: Get name of function					*/
/*  idx		: int		: Index					*/
/*  (returns)	: char *	: Name or null on error			*/

GFUNC	const char *el_funcn
	(	int	idx
	)
{
	const char	*name	;

	/* Check that the index is in the correct range for the master	*/
	/* table and that it does indeed refer to a public function.	*/
	if ( (idx <         0) ||
	     (idx >= _el_mcnt) || (_el_master[idx].value.tag != &tagPUB))
		name	= NULL ;
	else	name	= _el_master[idx].name ;

	return	name	;

}
