/***************************************************************************
    file	         : types.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"std.h"
#include	"eli.h"
#include	"interp.h"
#include	"syn.h"

extern	METHSET	el_hashMethSet	;

ELF::ELF
	(	const char	*name,
		int		length
	)
	:
	name	(name)
{
	code	= (int *)el_allocate(length * sizeof(int), "ELF::ELF") ;
//	fprintf	(stderr, "alloc ELF    %08x\n", (unsigned int)this) ;
}

ELF::~ELF ()
{
	free	((void *)code) ;
//	fprintf	(stderr, "free  ELF    %08x\n", (unsigned int)this) ;
}


/*  VALUE								*/
/*  VALUE	: Default VALUE constructor				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE ()
{
	tag	= &tagNUM ;
	val.num	= 0	  ;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor for a number			*/
/*  num		: int		: The number				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	int	num
	)
{
	tag	= &tagNUM ;
	val.num	= num	  ;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor for extant VALUE			*/
/*  v		: const VALUE &	: Extant value				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	const VALUE	&v
	)
{
	tag	= v.tag	 ;
	val	= v.val  ;
	if ((tag->flags & TF_SHARED) != 0) val.shared->ref  () ;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor for VALUE pointer			*/
/*  v		: VALUE *	: Value pointer				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	VALUE	*v
	)
{
	tag	= &tagPTR ;
	val.ptr	= v	  ;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor specific tag			*/
/*  _num	: int		: Number value				*/
/*  _tag	: ELTAG *	: Required tag				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	int	_num,
		ELTAG	*_tag
	)
{
	/* This constructor is mainly intended for costructing error	*/
	/* values, which are numbers but with tagNUM.			*/
	tag	= _tag	;
	val.num	= _num	;
}

VALUE::VALUE
	(	ELF	*_elf,
		ELTAG	*_tag
	)
{
	tag	= _tag	;
	val.elf = _elf	;
}


VALUE::VALUE
	(	void	*_user,
		ELTAG	*_tag
	)
{
	tag	= _tag	;
	val.user= _user	;
}



VALUE::~VALUE ()
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
}

void	VALUE::operator =
	(	int	num
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= &tagNUM ;
	val.num	= num	  ;
}

void	VALUE::operator =
	(	double	dbl
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= &tagDBL ;
	val.dbl	= dbl	  ;
}


void	VALUE::operator =
	(	const VALUE	&v
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= v.tag	 ;
	val	= v.val	 ;
	if ((tag->flags & TF_SHARED) != 0) val.shared->ref  () ;
}

void	VALUE::operator =
	(	VALUE	*ptr
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= &tagPTR ;
	val.ptr = ptr	  ;
}


int	VALUE::operator ==
	(	const VALUE	&op2
	)
{
	/* Equals/not-equals are allowed on different types, however,	*/
	/* the result is always false if the types are different.	*/
	if (tag != op2.tag) return 0 ;

	/* Compare according to type. Assume that any unknown type is	*/
	/* a user type.							*/
	switch (tag->tag)
	{
		case V_NUM :
		case V_ERR :
			return val.num  == op2.val.num  ;

		case V_DBL :
			return val.dbl  == op2.val.dbl  ;

		case V_STR :
			return strcmp (val.str->text, op2.val.str->text) == 0 ;

		case V_ELC :
		case V_PUB :
			return val.elf  == op2.val.elf  ;

		case V_FN  :
			return val.mc   == op2.val.mc   ;

		case V_VEC :
			return val.vec  == op2.val.vec  ;

		case V_HASH :
			return val.hash == op2.val.hash ;

		case V_PTR :
			return val.ptr  == op2.val.ptr  ;

		default	   :
			break	;
	}

	return val.user == op2.val.user ;
}
