/***************************************************************************
    file	         : vec.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<std.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"


/*  el_length	: Get vector size					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		:					*/

static	VALUE	el_length
	(	VALUE	*argv
	)
{
	return	VALUE (argv[0].val.vec->size) ;
}

/*  el_push	: Push value onto vector				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		:					*/

static	VALUE	el_push
	(	VALUE	*argv
	)
{
	return	VALUE (argv[0].val.vec->push (argv[1])) ;
}

/*  el_pop	: Pop value from vector					*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		:					*/

static	VALUE	el_pop
	(	VALUE	*argv
	)
{
	return	argv[0].val.vec->pop () ;
}

/*  el_shift	: Shift value from vector				*/
/*  argv	: VALUE *	: Arguments				*/
/*  (returns)	: VALUE		:					*/

static	VALUE	el_shift
	(	VALUE	*argv
	)
{
	return	argv[0].val.vec->shift () ;
}



static	MC	el_vecSpec   [] =
{
	{	"length",	{ 				0 },	el_length	},
	{	"push",		{ &tagANY,			0 },	el_push		},
	{	"pop",		{				0 },	el_pop		},
	{	"shift",	{				0 },	el_shift		},
	{	NULL,		{				0 },	NULL		}
}	;

static	ELTAG	*el_vecAllow [] =
{
	&tagVEC,
	0
}	;

METHSET	el_vecMethSet =
{
	0,
	el_vecAllow,
	el_vecSpec
}	;


/*  VEC									*/
/*  VEC		: Constructor for VEC object				*/
/*  size	: int		: Initial size				*/
/*  (returns)	: VEC		:					*/

VEC::VEC
	(	int	size
	)
	:
	size	(size),
	alloc	(size)
{
	vals	= new VALUE[size] ;
//	fprintf	(stderr, "alloc VEC    %08x\n", (unsigned int)this) ;
}

/*  VEC									*/
/*  VEC		: Destructor for VEC object				*/
/*  (returns)	:		:					*/

VEC::~VEC ()
{
	delete	[]vals	;
//	fprintf	(stderr, "free  VEC    %08x\n", (unsigned int)this) ;
}

/*  VEC									*/
/*  push	: Push value onto vector				*/
/*  val		: const VALUE &	: Value to push				*/
/*  (returns)	: int		: New vector size			*/

int	VEC::push
	(	const VALUE	&val
	)
{
	if (alloc <= size)
	{
		VALUE	*nval	= new VALUE[size + 8] ;
		for (int idx = 0 ; idx < size ; idx += 1)
			nval[idx] = vals[idx] ;
		delete	[] vals  ;
		vals  = nval     ;
		alloc = size + 8 ;
	}

	vals[size] = val ;
	size += 1	 ;
	return	size	 ;
}

/*  VEC									*/
/*  pop		: Pop value from vector					*/
/*  (returns)	: VALUE		: Popped value (or zero if empty)	*/

VALUE	VEC::pop ()
{
	if (size == 0) return VALUE (0) ;

	VALUE	res	= vals[size - 1] ;
	vals[size - 1]	= 0 ;
	size	       -= 1 ;
	return	res	;
}

/*  VEC									*/
/*  shift	: Shift value from vector				*/
/*  (returns)	: VALUE		: Shifted value (or zero if empty)	*/

VALUE	VEC::shift ()
{
	if (size == 0) return VALUE (0) ;

	VALUE	res	= vals[0] ;

	for (int idx = 1 ; idx < size ; idx += 1)
		vals[idx-1] = vals[idx] ;

	vals[size - 1]	= 0 ;
	size	       -= 1 ;
	return	res	;
}

/*  VALUE								*/
/*  VALUE	: VALUE constructor for a vector			*/
/*  vec		: VEC *		: The vector				*/
/*  (returns)	: VALUE		:					*/

VALUE::VALUE
	(	VEC	*vec
	)
{
	tag	= &tagVEC ;
	val.vec	= vec	  ;
}

/*  VALUE								*/
/*  operator =	: Assignment operator					*/
/*  vec		: VEC *		: Vector to assign			*/
/*  (returns)	: void		:					*/

void	VALUE::operator =
	(	VEC	*vec
	)
{
	if ((tag->flags & TF_SHARED) != 0) val.shared->deref() ;
	tag	= &tagVEC ;
	val.vec	= vec	  ;
}
