/***************************************************************************
    file	         : kb_macrotable.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_macrotable.h"
#include	"kb_objbase.h"
#include	"kb_form.h"
#include	"kb_table.h"


/*  KBMacroOpenTable							*/
/*  KBMacroOpenTable							*/
/* 		: Macro to open a table					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroOpenTable::KBMacroOpenTable
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "OpenTable")
{
}

/*  KBMacroOpenTable							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroOpenTable::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 2, 2, pError) ;
}

/*  KBMacroOpenTable							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroOpenTable::execute
	(	KBError		&pError
	)
{
	KBLocation location 
	(	m_exec->getDBInfo (),
		"table",
		m_exec->getServer (),
		m_args[0]
	)	;

	QDict<QString>	pDict	;
	KBNode		*node	;
	KB::ShowAs	showAs	= m_args[1] == "Design" ? KB::ShowAsDesign : KB::ShowAsData ;

	KB::ShowRC	rc	= KBAppPtr::getCallback()->openObject
						   (	location,
						 	showAs,
						 	pDict,
						 	pError
						   )	;

	fprintf
	(	stderr,
		"Macro::openTable: rc=%d\n",
		(int)rc
	)	;

	if ((rc != KB::ShowRCOK) && (rc != KB::ShowRCCancel))
		return	false	;

	node	= KBAppPtr::getCallback()->objectNode(location) ;

	fprintf
	(	stderr,
		"Macro::openTable: node=[%p]\n",
		(void *)node
	)	;

	m_exec->addNode ("table", node) ;
	return	true	;
}

/*  ------------------------------------------------------------------  */

/*  KBMacroCloseTable							*/
/*  KBMacroCloseTable							*/
/* 		: Macro to close a table					*/
/*  exec	: KBMacroExec *	   : Macro executor			*/
/*  (returns)	: KBMacroPromptBox :					*/

KBMacroCloseTable::KBMacroCloseTable
	(	KBMacroExec	*exec
	)
	:
	KBMacroInstr (exec, "CloseTable")
{
}

/*  KBMacroCloseTable							*/
/*  init	: Initialise macro instruction				*/
/*  args	: const QStringList &	: Macro arguments		*/
/*  comment	: const QString &	: Macro comment			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

bool	KBMacroCloseTable::init
	(	const QStringList	&args,
		const QString		&comment,
		KBError			&pError
	)
{
	return	KBMacroInstr::init (args, comment, 1, 1, pError) ;
}

/*  KBMacroCloseTable							*/
/*  execute	: Execute instruction					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBMacroCloseTable::execute
	(	KBError		&
	)
{
	KBNode	  *node = m_exec->getNode (m_args[0], "table") ;

	if ((node != 0) && (node->isForm() != 0))
		node->isForm()->getDocRoot()->doRequestClose(1) ;

	return	true	;
}

/*  ------------------------------------------------------------------  */


NEWMACRO(OpenTable )
NEWMACRO(CloseTable)

/*  ------------------------------------------------------------------  */

#ifdef	__DOCS
  <macro name="OpenTable">
    <arg type="object:table" legend="Table Name"/>
    <arg type="choice" legend="Mode">
      <choice value="Data"/>
      <choice value="Design"/>
    </arg>
      <![CDATA[
        <h3>Open Table</h3>
        Opens the named table. Control will return immediately.
      ]]>
  </macro>
  <macro name="CloseTable">
    <arg type="object:table" legend="Table Name"/>
      <![CDATA[
        <h3>Close Table</h3>
        Closes the named table.
      ]]>
  </macro>
#endif	// __DOCS
