/***************************************************************************
    file	         : kb_macroform.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_MACROFORM_H
#define	__KB_MACROFORM_H

#include	"kb_macro.h"
#include	"libextra_exports.h"

/*  KBMacroOpenForm							*/
/*  ---------------							*/
/*  Macro used to open a form						*/

class	LIBEXTRA_API	KBMacroOpenForm : public KBMacroInstr
{
public	:

	KBMacroOpenForm	(KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	(KBError &) ;
}	;

/*  KBMacroCloseForm							*/
/*  ----------------							*/
/*  Macro used to close a form						*/

class	LIBEXTRA_API	KBMacroCloseForm : public KBMacroInstr
{
public	:

	KBMacroCloseForm(KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	(KBError &) ;
}	;

/*  KBMacroNavigate							*/
/*  ----------------							*/
/*  Macro used to go to a navigate in a form				*/

class	LIBEXTRA_API	KBMacroNavigate : public KBMacroInstr
{
public	:

	KBMacroNavigate	(KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	(KBError &) ;
}	;

/*  KBMacroReloadForm							*/
/*  -----------------							*/
/*  Reload form data with option filter and sorting			*/

class	LIBEXTRA_API	KBMacroReloadForm : public KBMacroInstr
{
public	:

	KBMacroReloadForm (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	(KBError &) ;
}	;

/*  KBMacroFormField							*/
/*  ----------------							*/
/*  Class used by form macros that access fields.			*/

class	LIBEXTRA_API	KBMacroFormField : public KBMacroInstr
{
protected :

	KBItem	*getFormField ()	;

public	:

	KBMacroFormField (KBMacroExec *, cchar *) ;
}	;

/*  KBMacroGetField							*/
/*  ----------------							*/
/*  Get a value from a field in a form					*/

class	LIBEXTRA_API	KBMacroGetField : public KBMacroFormField
{
public	:

	KBMacroGetField (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	(KBError &) ;
}	;

/*  KBMacroSetField							*/
/*  ----------------							*/
/*  Set value in a field in a form					*/

class	LIBEXTRA_API	KBMacroSetField : public KBMacroFormField
{
public	:

	KBMacroSetField (KBMacroExec *) ;

	virtual	bool	init
		(	const QStringList	&,
			const QString		&,
			KBError			&
		)	;

	bool	execute	(KBError &) ;
}	;

#endif	// __KB_MACROFORM_H
