/***************************************************************************
    file	         : kb_attrnav.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_ATTRNAV_H
#define	__KB_ATTRNAV_H

#include	"libkbase_exports.h"
#include	"kb_attr.h"

#if		! __KB_RUNTIME
#include	"kb_attritem.h"
#endif


/*  KBAttrNav								*/
/*  ----------								*/
/*  This class handles block scroll-bar and mini-navigation options.	*/
/*  It maintains backward compatability with earlier releases. Values	*/
/*  are:								*/
/*	0	- Neither scroll nor min-nav				*/
/*	1	- Both							*/
/*	2	- Scroll only						*/
/*	3	- Mini-nav only						*/

class	LIBKBASE_API	KBAttrNav : public KBAttrStr
{
public	:

	KBATTRCTRDEF (KBAttrNav, KBAttrStr)

	uint			getFlags () ;

#if	! __KB_RUNTIME
	virtual	KBAttrDlg	*getAttrDlg
				(	QWidget			*,
					KBAttrItem		*,
					QDict<KBAttrItem>	&
				)	;
	virtual	QString		displayValue	(const QString &) ;
#endif
}	;

#define	NAV_SCROLL	0x01
#define	NAV_MINI	0x02

#endif	// __KB_ATTRNAV_H
