/***************************************************************************
    file	         : kb_attrnavdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_attrnav.h"
#include	"kb_node.h"


#ifndef 	_WIN32
#include 	"kb_attrnavdlg.moc"
#else
#include 	"kb_attrnavdlg.h"
#endif





/*  KBAttrNavDlg							*/
/*  KBAttrNavDlg: Constructor for navigation dialog			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttr *		: Associated attribute		*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: All attributes		*/
/*  (returns)	: KBAttrNavDlg		:				*/

KBAttrNavDlg::KBAttrNavDlg
	(	QWidget			*parent,
		KBAttr			*attr,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_nav    	(this)
{
	QVBoxLayout *layMain	= new QVBoxLayout (this) ;

	layMain	->addWidget (&m_nav)	;
	layMain	->addStretch()		;

	m_nav	.insertItem(TR("None"	  )) ;
	m_nav	.insertItem(TR("Both"	  )) ;
	m_nav	.insertItem(TR("Scrollbar")) ;
	m_nav	.insertItem(TR("MiniNav"  )) ;
}

/*  KBAttrNavDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool		: False, no modal dialog		*/

bool	KBAttrNavDlg::init
	(	const QString	&value
	)
{
	int	c = 0 ;

	if	(value == "Yes"	     ) c = 1 ;
	else if (value == "Scrollbar") c = 2 ;
	else if (value == "MiniNav"  ) c = 3 ;

	m_nav.setCurrentItem (c) ;
	return	false	;
}

/*  KBAttrNavDlg							*/
/*  value	: Get value						*/
/*  (returns)	: QString		:					*/

QString	KBAttrNavDlg::value ()
{
	QString	v	= "No" ;

	switch (m_nav.currentItem())
	{
		case 1	: v = "Yes"	  ; break ;
		case 2	: v = "Scrollbar" ; break ;
		case 3	: v = "MiniNav"	  ; break ;
		default	:		    break ;
	}

	return	v ;
}
