/***************************************************************************
    file	         : kb_attrserverdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlayout.h>

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_node.h"
#include	"kb_docroot.h"
#include	"kb_dbinfo.h"

#ifndef 	_WIN32
#include 	"kb_attrserverdlg.moc"
#else
#include 	"kb_attrserverdlg.h"
#endif


/*  KBAttrServerDlg							*/
/*  KBAttrServerDlg							*/
/*		: Constructor for alignment dialog			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttr *		: Associated attribute		*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/	
/*  (returns)	: KBAttrServerDlg:					*/

KBAttrServerDlg::KBAttrServerDlg
	(	QWidget			*parent,
		KBAttr			*attr,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_server    	(this)
{
	QVBoxLayout *layMain	= new QVBoxLayout(this) ;
	KBNode	    *node	= m_item->attr()->getOwner() ;

	layMain->addWidget  (&m_server) ;
	layMain->addStretch ()	;

	const KBLocation &locn	 = node->getDocRoot()->getLocation() ;
	KBDBInfo	 *dbInfo = node->getDocRoot()->getDBInfo  () ;
	KBServerInfo	 *self	 = dbInfo->findServer (locn.docLocn) ;
	KBServerInfo	 *files	 = dbInfo->findServer (KBLocation::m_pFile) ;

	if (!self ->dbType().isEmpty()) m_server.insertItem ("Self") ;
	if (!files->dbType().isEmpty()) m_server.insertItem (KBLocation::m_pFile) ;

	QListIterator<KBServerInfo>
			*svIter = dbInfo->getServerIter() ;
	KBServerInfo	*svInfo	;
	QString		text	;

	while ((svInfo = svIter->current()) != 0)
	{
		m_server.insertItem (svInfo->serverName()) ;
		(*svIter) += 1 ;
	}

	delete	svIter	;
}

/*  KBAttrServerDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool		  : Always false, no modal dialog	*/

bool	KBAttrServerDlg::init
	(	const QString	&value
	)
{
	for (int idx = 0 ; idx < m_server.count() ; idx += 1)
		if (m_server.text(idx) == value)
		{	m_server.setCurrentItem (idx) ;
			break	;
		}

	return	false	;
}

/*  KBAttrServerDlg							*/
/*  value	: Get value						*/
/*  (returns)	: void		:					*/

QString	KBAttrServerDlg::value ()
{
	return	m_server.currentText() ;
}

