/***************************************************************************
    file	         : kb_attrvpagedlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<qlabel.h>
#include	<qgroupbox.h>
#include	<qcheckbox.h>
#include	<qtextview.h>
#include	<qspinbox.h>
#include	<qpainter.h>
#include	<qlayout.h>

#ifndef		_WIN32
#include	"kb_attrvpagedlg.moc"
#else
#include	"kb_attrvpagedlg.h"
#endif

#include	"kb_attrvpage.h"




/*  KBAttrVPageItem							*/
/*  KBAttrVPageItem							*/
/*		: Constructor for report margins for property dialog	*/
/*  attrVPage	: KBAttrVPage *   : Parent attribute			*/
/*  (returns)	: KBAttrVPageItem :					*/

KBAttrVPageItem::KBAttrVPageItem
	(	KBAttrVPage	*attrVPage
	)
	:
	KBAttrItem	(attrVPage),
	m_attrVPage	(attrVPage)
{
	m_enabled	= m_attrVPage->m_enabled	;
	m_colWidth	= m_attrVPage->m_colWidth	;
	m_rowHeight	= m_attrVPage->m_rowHeight	;
	m_colGap	= m_attrVPage->m_colGap		;
	m_rowGap	= m_attrVPage->m_rowGap		;
	m_borders	= m_attrVPage->m_borders	;
	m_skip		= m_attrVPage->m_skip		;
}

/*  KBAttrVPageItem							*/
/* ~ KBAttrVPageItem							*/
/*		: Destructor for report margins for property dialog	*/
/*  (returns)	:		:					*/

KBAttrVPageItem::~KBAttrVPageItem ()
{
}

/*  KBAttrVPageItem							*/
/*  getAttrDlg	: Get dialog for editing margin settings		*/
/*  parent	: QWidget *	      : Parent widget			*/
/*  attrDict	: QDict<KBAttrItem> & : Dictionary or other attributes	*/
/*  (returns)	: KBAttrDlg *	      :					*/

KBAttrDlg
	*KBAttrVPageItem::getAttrDlg
	(	QWidget			*parent,
		QDict<KBAttrItem>	&attrDict
	)
{
	return	new KBAttrVPageDlg (parent, m_attrVPage, this, attrDict) ;
}

/*  KBAttrVPageItem							*/
/*  clear	: Clear values						*/
/*  (returns)	: void		:					*/

void	KBAttrVPageItem::clear ()
{
	m_enabled	= false	;
	m_colWidth	= 0	;
	m_rowHeight	= 0	;
	m_colGap	= 0	;
	m_rowGap	= 0	;
	m_borders	= false	;
	m_skip		= false	;
}

/*  KBAttrVPageItem							*/
/*  save	: Save values back to attribute				*/
/*  (returns)	: void		:					*/

void	KBAttrVPageItem::save ()
{
	m_attrVPage->m_enabled	 = m_enabled	;
	m_attrVPage->m_colWidth	 = m_colWidth	;
	m_attrVPage->m_rowHeight = m_rowHeight	;
	m_attrVPage->m_colGap	 = m_colGap	;
	m_attrVPage->m_rowGap	 = m_rowGap	;
	m_attrVPage->m_borders	 = m_borders	;
	m_attrVPage->m_skip	 = m_skip	;
}

/*  KBAttrVPageItem							*/
/*  displayValuue: Get text for display in preorty dialog		*/
/*  (returns)	 : QString	:					*/

QString	KBAttrVPageItem::displayValue ()
{
	return	QString	(TR("%1: %2,%3,%4,%5: borders %6, skip %7"))
			.arg(m_enabled  ? TR("On") : TR("Off"))
			.arg(m_colWidth )
			.arg(m_rowHeight)
			.arg(m_colGap   )
			.arg(m_rowGap   )
			.arg(m_borders  ? TR("On") : TR("Off"))
			.arg(m_skip     ? TR("On") : TR("Off"))
			;
}

/*  ------------------------------------------------------------------	*/

class	KBAttrVPageSampler : public QWidget
{
protected :

	virtual	void	paintEvent	(QPaintEvent *) ;

public	:

	KBAttrVPageSampler		(QWidget *) ;
}	;

KBAttrVPageSampler::KBAttrVPageSampler
	(	QWidget		*parent
	)
	:
	QWidget	(parent)
{
}

void	KBAttrVPageSampler::paintEvent
	(	QPaintEvent	*
	)
{
	QPainter p (this) ;

	p.fillRect
	(	0,
		0,
		width (),
		height(),
		QBrush(Qt::gray)
	)	;

	int	  w	= width () ;
	int	  h	= height() ;

	if (w < 200) w = 200 ;
	if (h < 200) h = 200 ;

	const int lm	= 10 ;
	const int tm 	= 10 ;
	const int cg	= 10 ;
	const int rg	= 10 ;
	const int cw	= (w - (lm * 2) - (cg * 1)) / 2 ;
	const int rh	= (h - (tm * 2) - (rg * 3)) / 4 ;

	p.setPen   (Qt::black) ;
	p.setFont  (QFont("Times", 8)) ;

	for (uint r = 0 ; r < 4 ; r += 1)
		for (uint c = 0 ; c < 2 ; c += 1)
		{
			QRect	rect
			(	lm + c * (cw + cg),
				tm + r * (rh + rg),
				cw,
				rh
			)	;

			p.fillRect (rect, QBrush(Qt::white)) ;
			p.drawRect (rect) ;

			p.drawText
			(	rect.topLeft() + QPoint(10,20),
				QString(TR("Blah blah %1")).arg(r*2 + c)
			)	;
		}
}

/*  ------------------------------------------------------------------	*/

/*  KBAttrVPageDlg							*/
/*  KBAttrVPageDlg							*/
/*		: Constructor for margin dialog				*/
/*  parent	: QWidget *		: Parent widget			*/
/*  attr	: KBAttrVPage *		: Associated attribute		*/
/*  item	: KBAttrVPageItem *	: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrVPageDlg		:				*/

KBAttrVPageDlg::KBAttrVPageDlg
	(	QWidget			*parent,
		KBAttrVPage		*attr,
		KBAttrVPageItem	*item,
		QDict<KBAttrItem>	&attrDict
	)
	:
	KBAttrDlg	(parent, attr, item, attrDict),
	m_attrItem	(item)
{
	QHBoxLayout	*layTop	 = new QHBoxLayout (this  ) ;
	QVBoxLayout	*layGrp	 = new QVBoxLayout (layTop) ;

	m_enabled	= new QCheckBox (TR("Enabled"), this) ;
	m_group		= new QGroupBox
			  (	2,
				QGroupBox::Horizontal,
				QString  ::null,
				this
			  )	;

	layGrp->addWidget (m_enabled) ;
	layGrp->addWidget (m_group  ) ;
	layTop->addWidget (new KBAttrVPageSampler (this)) ;

	new QLabel	(TR("Column width"), m_group) ;
	m_colWidth	= new QSpinBox (0, 1000, 1, m_group) ;
	m_colWidth ->setFixedWidth (100) ;

	new QLabel	(TR("Row height"  ), m_group) ;
	m_rowHeight	= new QSpinBox (0, 1000, 1, m_group) ;
	m_rowHeight->setFixedWidth (100) ;

	new QLabel	(TR("Column gap"  ), m_group) ;
	m_colGap	= new QSpinBox (0, 1000, 1, m_group) ;
	m_colGap   ->setFixedWidth (100) ;

	new QLabel	(TR("Row gap"     ), m_group) ;
	m_rowGap	= new QSpinBox (0, 1000, 1, m_group) ;
	m_rowGap   ->setFixedWidth (100) ;

	new QLabel	(TR("Draw borders"), m_group) ;
	m_borders	= new QCheckBox("",  m_group) ;

	new QLabel	(TR("Skip prompt" ), m_group) ;
	m_skip		= new QCheckBox("",  m_group) ;

	connect
	(	m_enabled,
		SIGNAL	(toggled   (bool)),
		m_group,
		SLOT	(setEnabled(bool))
	)	;
}

/*  KBAttrVPageDlg							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBAttrVPageDlg::value ()
{
	return	QString("") ;
}

/*  KBAttrVPageDlg							*/
/*  init	: Initialise for editing				*/
/*  value	: const QString & : Value				*/
/*  (returns)	: bool		  : Always false, no modal dialog	*/

bool	KBAttrVPageDlg::init
	(	const QString	&
	)
{
	return	false	;
}

/*  KBAttrVPageDlg							*/
/*  init	: Initialise for editing				*/
/*  (returns)	: bool		: True if modal dialog executed		*/

bool	KBAttrVPageDlg::init()
{
	m_enabled  ->setChecked	(m_attrItem->m_enabled  ) ;
	m_group    ->setEnabled (m_attrItem->m_enabled  ) ;
	m_colWidth ->setValue	(m_attrItem->m_colWidth ) ;
	m_rowHeight->setValue	(m_attrItem->m_rowHeight) ;
	m_colGap   ->setValue	(m_attrItem->m_colGap   ) ;
	m_rowGap   ->setValue	(m_attrItem->m_rowGap   ) ;
	m_borders  ->setChecked (m_attrItem->m_borders	) ;
	m_skip	   ->setChecked (m_attrItem->m_skip	) ;

	return	false	;
}

/*  KBAttrVPageDlg							*/
/*  save	: Save values back to associated attribute item		*/
/*  (returns)	: bool		: True if modal dialog executed		*/

void	KBAttrVPageDlg::save ()
{
	m_attrItem->m_enabled	= m_enabled  ->isChecked() ;
	m_attrItem->m_colWidth	= m_colWidth ->value	() ;
	m_attrItem->m_rowHeight	= m_rowHeight->value	() ;
	m_attrItem->m_colGap	= m_colGap   ->value	() ;
	m_attrItem->m_rowGap	= m_rowGap   ->value	() ;
	m_attrItem->m_borders	= m_borders  ->isChecked() ;
	m_attrItem->m_skip	= m_skip     ->isChecked() ;
}
