/***************************************************************************
    file	         : kb_attrvpagedlg.h
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef	_KB_ATTRVPAGEDLG_H
#define	_KB_ATTRVPAGEDLG_H

#include	"kb_attritem.h"
#include	"kb_attrdlg.h"

class	QGroupBox	;
class	QCheckBox	;
class	QSpinBox	;
class	KBAttrVPage	;

/*  KBAttrVPageItem							*/
/*  ----------------							*/
/*  Derived item used in property dialogs to hold temporary values of	*/
/*  attributes, in this case the report virtual page settings.		*/

class	LIBKBASE_API	KBAttrVPageItem : public KBAttrItem
{
	KBAttrVPage	*m_attrVPage	;
	bool		m_enabled	;
	int		m_colWidth	;
	int		m_rowHeight	;
	int		m_colGap	;
	int		m_rowGap	;
	bool		m_borders	;
	bool		m_skip		;

public	:

	KBAttrVPageItem	(KBAttrVPage *);
	~KBAttrVPageItem	()		;

	virtual	QString		displayValue	() ;
	virtual	void		clear		() ;
	virtual	void		save		() ;

	virtual	KBAttrDlg	*getAttrDlg	(QWidget *, QDict<KBAttrItem> &) ;

	friend	class		KBAttrVPageDlg	;
}	;

/*  KBAttrVPageDlg							*/
/*  --------------							*/
/*  Dialog component for virtual page settings				*/

class	LIBKBASE_API	KBAttrVPageDlg : public KBAttrDlg
{
	Q_OBJECT

	KBAttrVPageItem	*m_attrItem	;

	QCheckBox	*m_enabled	;
	QGroupBox	*m_group	;
	QSpinBox	*m_colWidth	;
	QSpinBox	*m_rowHeight	;
	QSpinBox	*m_colGap	;
	QSpinBox	*m_rowGap	;
	QCheckBox	*m_borders	;
	QCheckBox	*m_skip		;

public	:

	KBAttrVPageDlg
	(	QWidget			*,
		KBAttrVPage		*,
		KBAttrVPageItem		*,
		QDict<KBAttrItem>	&
	)	;

	virtual	bool		init		(const QString &) ;
	virtual	bool		init		() ;
	virtual	void		save		() ;
	virtual QString		value		() ;
}	;

#endif	// _KB_ATTRVPAGEDLG_H
