/***************************************************************************
    file	         : kb_complink.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COMPLINK_H
#define	__KB_COMPLINK_H

#include	"kb_classes.h"
#include	"kb_framer.h"

#include	"libkbase_exports.h"


/*  KBCompLink								*/
/*  ----------								*/
/*  This class ised used for linked components. It itself has just	*/
/*  the component location (server and name) but the implementation	*/
/*  loads and handles the component.					*/

class	LIBKBASE_API	KBCompLink : public KBFramer
{
	KBAttrStr	m_server	;
	KBAttrStr	m_component	;

	KBAttrStr	*m_attrOver	;

	bool			initialise	(KBError &) ;
	void			setOverrides	()	  ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	()	  ;
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBCompLink	(KBNode *, const QDict<QString> &, bool * = 0)	;
	KBCompLink	(KBNode *, KBCompLink *) ;
	virtual	 ~KBCompLink	() ;

#if	! __KB_RUNTIME
	virtual	void		designPopup	(QMouseEvent *, uint) ;
#endif

	virtual	void		printNode  	(QString &,int)	;
	virtual	KBNode		*replicate	(KBNode *)	;
	virtual	void		showAs		(KB::ShowAs)	;

	virtual	KBNode		*endParse  	()	 	;
	void			checkOverrides	()		;
}	;

#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	compLinkPropDlg
			(	KBCompLink	*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// __KB_COMPLINK_H
