/***************************************************************************
    file	         : kb_copyxml.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYXML_H
#define	__KB_COPYXML_H

#include 	"libkbase_exports.h"

#include	<qfile.h>
#include	<qtextstream.h>
#include	<qstringlist.h>

#include	"kb_dom.h"
#include	"kb_location.h"
#include	"kb_copybase.h"


class	KBCopyXMLSAX	;


class	LIBKBASE_API	KBCopyXML : public KBCopyBase
{
public	:

	enum
	{	ErrPad		= 0,
		ErrSkip		= 1,
		ErrAbort	= 2
	}	;

private	:

	bool		m_srce	     ;
	KBLocation	m_location   ;

	QString		m_file	     ;	/* File name			*/
	QString		m_mainTag    ;	/* Tag for main XML element	*/
	QString		m_rowTag     ;	/* Tag for row XML element	*/
	uint		m_erropt     ;	/* Line error option		*/

	QStringList	m_names	     ;	/* Tag or attribute name	*/
	QStringList	m_destNames  ;  /* Actual ones to use		*/
	QValueList<bool>m_asattr     ;	/* Output as attribute		*/

	QFile		m_io	     ;
	uint		m_nRows	     ;
	QTextStream	m_stream     ;

	QString		m_useFile    ;	/* Paramater substituted ....	*/
	QString		m_useMainTag ;
	QString		m_useRowTag  ;


public	:

	KBCopyXML		(bool, KBLocation &)	;
	virtual	~KBCopyXML	()		;

	virtual	cchar		*tag		() ;

	virtual	bool		valid		(KBError     &) ;
	virtual	bool		set		(QDomElement &, KBError &) ;
	virtual	void		def		(QDomElement &) ;

	virtual	void		getColumnNames	(QStringList &) ;
	virtual	bool		prepare		(const QDict<QString>   &, KBCopyBase *) ;
	virtual	int		getNumCols	() ;
	virtual	int		getRow		(KBValue *, uint,  bool &) ;
	virtual	bool		putRow		(KBValue *, uint  ) ;
	virtual	bool		finish		(QString &) ;

	void			setMainTag	(const QString &) ;
	void			setRowTag	(const QString &) ;
	void			setErrOpt	(uint) ;
	void			setFile		(const QString &) ;
	void			addField	(const QString &, bool) ;

	inline	uint		&getErrOpt	() { return m_erropt  ; }
	inline	const QString	&getFile	() { return m_file    ; }
	inline	const QString	getMainTag	() { return m_mainTag ; }
	inline	const QString	getRowTag	() { return m_rowTag  ; }

	bool			getField	(uint, QString &, bool &) ;

	void			reset		() ;

	virtual	int	execute
		(	KBCopyBase	*,
			KBValue		*,
			int		,
			KBCopyExec 	*
		)	; 
}	;

#endif	// __KB_COPYXML_H
