/***************************************************************************
    file	         : kb_ctrl.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_CTRL_H
#define	_KB_CTRL_H

#include	"libkbase_exports.h"

#include	"kb_item.h"


class		KBEventFilter	;
class		KBControl	;
class		KBCtrlMorph	;

/*  KBEventFilter							*/
/*  -------------							*/
/*  Helper class used to provide and event filter. Not part of		*/
/*  KBControl, since KBControl must not be derived from QObject.	*/

class LIBKBASE_API	KBEventFilter : public QObject
{
	Q_OBJECT

	KBControl	*m_control	;
	QWidget		*m_widget	;

protected :

	virtual bool	eventFilter	(QObject *, QEvent *) ;

public	:

	KBEventFilter	(KBControl *, QWidget *) ;
}	;


/*  KBControl								*/
/*  --------								*/
/*  This class is used as a standard interface to things that appear on	*/
/*  the display, for instance buttons and text fields.			*/

class	LIBKBASE_API	KBControl 
{
	KBEventFilter		m_filter	;
	QWidget			*m_widget	;
	KBDisplay		*m_display	;
	KBObject		*m_object	;
	KBItem			*m_item		;
	KBNodeMonitor		*m_monitor	;

	KBError			m_lError	;
	bool			m_lastState	;
	bool			m_morphed	;

	QRect			m_rect		;
	bool			m_enabled	;
	bool			m_visible	;
	QPalette		m_palette	;
	QFont			m_font		;

	void			setupWidget	()	;
	void			updateMorph	()	;

protected :

	KBValue			m_curVal	;
	KB::ShowAs		m_showing	;
	uint			m_drow		;

	uint			ctrlSetFrame	(QFrame *) ;
	virtual	bool		eventFilter	(QObject *, QEvent *)	;
	KBValue			getIniValue	() ;
	virtual	void		setMonitor	(const KBValue &)	;
	bool			startUpdate	() ;

public	:

		KBControl	(QWidget *, KBDisplay *, KBObject *) ;
		KBControl	(QWidget *, KBDisplay *, KBItem   *, uint) ;
	virtual~KBControl	() ;

	virtual	void		setGeometry	(int, int, int, int)	;
	virtual	void		setGeometry	(const QRect &)		;

	KBDisplay 		*getDisplay	()			;
	virtual	QWidget		*topWidget	()			;
	virtual	QWidget		*mainWidget	()			;

	virtual	void		showName	()			;
	virtual void		showMonitor	(QListViewItem  *)	;
	virtual	void		setPalette	(const QPalette *)	;
	virtual	void		setFont		(const QFont    *)	;
	virtual	void		showAs		(KB::ShowAs)		;
	virtual	QSize		sizeHint 	() const		;
	virtual	void		setFocus	()			;
	virtual	void		giveFocus	() = 0			;
	virtual	void		redraw		()			;

	virtual	QRect		geometry	()			;

	virtual void		setEnabled	(bool)			;
	virtual void		setVisible	(bool)			;
	virtual bool		isEnabled	() 			;
	virtual bool		isVisible	()			;
	
	virtual	void		setData		(void *)		;
	virtual	void		setValue	(const KBValue &)	;
	virtual	KBValue		getValue	()			;
	virtual	void		clearValue	(bool)			;
	virtual	bool		changed		()			;
	virtual	bool		isEmpty		()			;
	virtual	bool		isValid		(bool)			;

	virtual	void		repaintMorph	(QPainter *)		;
	virtual	void		paintMorph	(QPainter *, const QString &) ;

	void			setMorphed	(bool)			;
	void			eraseArea	()			;
	virtual	QString		morphText	()			;

#if	! __KB_EMBEDDED
	virtual	QVariant	property	(cchar *)		;
	virtual	bool		setProperty	(cchar *, const QVariant &) ;
#endif

	inline	uint	getDRow ()
	{
		return	m_drow	;
	}
	inline	void	setError
		(	const KBError	&pError
		)
	{
		m_lError = pError;
	}
	inline	const KBError &lastError ()
	{
		return	m_lError ;
	}
	inline	bool	isMorphed ()
	{
		return	m_morphed;
	}

	virtual	bool	write	(KBWriter *, QRect, const KBValue &, bool, int &) ;

	friend	class	KBEventFilter	;
}	;

/*  We need to trap setFocus in all controls in order that the system	*/
/*  can check that control can leave the current item. Provie a macro	*/
/*  to insert the neccessary code.					*/

#define	SETFOCUS	\
	virtual	void	setFocus ()			\
	{	KBControl::setFocus () ;			\
	}

/*  See the comment in KBControl::sizeHint () for an explantion of this	*/
/*  bit of code, but basically we need to trap sizeHint () in all	*/
/*  controls								*/

#define	SIZEHINT	\
	virtual	QSize	sizeHint () const		\
	{	return KBControl::sizeHint () ;		\
	}


#endif	// _KB_CTRL_H
