/***************************************************************************
    file	         : kb_deleter.h
    copyright            : (C) 1999,2000,2001,2002,2003,2004 by Mike Richardson
			   (C) 2001,2002,2003,2004 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qtimer.h>

#ifndef		_WIN32
#include	"kb_deleter.moc"
#else
#include	"kb_deleter.h"
#endif

/*  KBDeleter								*/
/*  KBDeleter	: Constructor for asynchronous deletion object		*/
/*  (returns)	: KBDeleter	:					*/

KBDeleter::KBDeleter ()
{
//	fprintf
//	(	stderr,
//		"KBDeleter::KBDeleter: created deleter\n"
//	)	;
}

/*  KBDeleter								*/
/*  enqueueObject: Enqueue object for later deletion			*/
/*  object	 : QObject *	: Object in question			*/
/*  (returns)	 : void		:					*/

void	KBDeleter::enqueueObject
	(	QObject		*object
	)
{
	/* If the queue is empty then start a single shot timer, so	*/
	/* that the queue can be processed as soon as the program would	*/
	/* otherwise idle.						*/
	if (m_queue.isEmpty()) QTimer::singleShot (0, this, SLOT(slotDelete())) ;
	m_queue.enqueue (object) ;

//	fprintf
//	(	stderr,
//		"KBDeleter::enqueueObject: added object [%p]\n",
//		(void *)object
//	)	;
}

/*  KBDeleter								*/
/*  slotDelete	: Delete objects from queue				*/
/*  (returns)	: void		:					*/

void	KBDeleter::slotDelete ()
{
//	fprintf
//	(	stderr,
//		"KBDeleter::slotDelete: deleting objects\n"
//	)	;

	while (!m_queue.isEmpty())
		delete	m_queue.dequeue() ;
}

/*  KBDeleter								*/
/*  addObject	: Add object to deleter queue				*/
/*  object	: QObject *	: Object in question			*/
/*  (returns)	: void		:					*/

void	KBDeleter::addObject
	(	QObject		*object
	)
{
	static	KBDeleter	*deleter ;
	if (deleter == 0) deleter = new KBDeleter ;
	deleter->enqueueObject (object)  ;
}
