/***************************************************************************
    file	         : kb_dispscroller.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DISPSCROLLER_H
#define	__KB_DISPSCROLLER_H

#include 	"libkbase_exports.h"

#include	<qscrollview.h>
#include	<qlabel.h>
#include	<qlayout.h>
#include	<qlist.h>
#include	<qtimer.h>

#include	"kb_classes.h"
#include	"kb_ruler.h"
#include	"kb_recordnav.h"

class		KBDispWidget	;


/*  KBDispScroller							*/
/*  --------------							*/
/*  This class is a wrapper around a scroll view, and is used as the	*/
/*  canvas at the top level of a form, or report in design view.	*/

class	LIBKBASE_API	KBDispScrollArea : public QScrollView
{
	Q_OBJECT


	KBDisplay	*m_display	;
	KBRuler		*m_rulerX	;
	KBRuler		*m_rulerY	;
	KBFormBlock	*m_formblock	;

	uint		m_showBar	;
	bool		m_stretch	;

	QList<KBItem>	m_morphList	;
						/* Data mode		*/
	QScrollBar	*m_vBar		;	/* Record scroll bar	*/
	KBRecordNav	*m_rLabel	;	/* Record count label	*/
						/* Design mode		*/
	QScrollBar	*m_vBar_d	;	/* Record scroll bar	*/
	KBRecordNav	*m_rLabel_d	;	/* Record count label	*/

	bool		m_inSetRange	;
	KB::ShowAs	m_showing	;
	QTimer		m_scrollTimer	;
	QTimer		m_drawTimer1	;
	QTimer		m_drawTimer2	;
	QPoint		m_mouseDownAt	;
	QRect		m_drawRect	;

protected :

	virtual void	contentsWheelEvent	  (QWheelEvent  *) ;
	virtual void	contentsMousePressEvent	  (QMouseEvent  *) ;
	virtual void	contentsMouseMoveEvent	  (QMouseEvent  *) ;
	virtual	void	contentsMouseReleaseEvent (QMouseEvent  *) ;
	virtual	void	drawContents		  (QPainter     *, int, int, int, int) ;

	virtual	void	resizeEvent		  (QResizeEvent *) ;
	virtual	void	setHBarGeometry		  (QScrollBar   &, int, int, int, int) ;
	virtual	void	setVBarGeometry		  (QScrollBar   &, int, int, int, int) ;

	virtual	void	contentsMouseDoubleClickEvent
						  (QMouseEvent  *) ;

	virtual	bool	focusNextPrevChild	  (bool);

protected slots :

	void		vbarMoved		  ()	;
	void		morphDestroyed		  ()	;
	virtual	bool	eventFilter		  (QObject *, QEvent *)	;
	void		scrollTimeout		  ()	;
	void		drawTimeout		  ()	;
	void		slotAction		  (KB::Action) ;

public	:

	KBDispScrollArea(QWidget *, KBDisplay *, KBRuler *, KBRuler *, uint, bool)  ;
	virtual		~KBDispScrollArea () ;

	void		showAs		(KB::ShowAs)	;
	void		setStretchable	(bool)	;
	void		setShowbar	(uint)	;

	void		setRowRange	(uint, uint, uint, uint, uint) ;
	QSize		effectiveSize	(QSize) ;
	void		sizeAdjusted	() ;

	void		addMorph	(KBItem *) ;
	void		remMorph	(KBItem *) ;
	void		updateMorph	(KBItem *, const QRect &) ;
	void		updateMorph	(KBItem *, uint) ;

	void		moveTags	(KBDispWidget *, uint) ;

	void		makeVisible	(const QRect &, QFocusEvent::Reason) ;

	virtual	void	addChild	(QWidget *, int = 0, int = 0) ;
	virtual	void	setContentsPos	(int, int) ;
}	;


/*  KBDispScrollArea							*/
/*  ----------------							*/
/*  At the top-level of a table in design view, we show a pair of	*/
/*  rulers, as well as the scroll view that is the canvas that the	*/
/*  design appears on. This class encapsulates the rulers and the	*/
/*  canvas. Note that the rulers to not appear in form design.		*/

class	LIBKBASE_API	KBDispScroller : public QWidget
{
	KBRuler			*m_rulerX	;
	KBRuler			*m_rulerY	;
	KBDispScrollArea	m_scroller	;
	QGridLayout		m_layout	;

public	:

	KBDispScroller	(QWidget *, KBDisplay *, uint, bool, bool)  ;
	virtual		~KBDispScroller () ;

	void		showAs		(KB::ShowAs)	;
	void		setStretchable	(bool)	;
	void		setShowbar	(uint)	;

	void		setRowRange	(uint, uint, uint, uint, uint) ;
	QSize		effectiveSize	(QSize) ;
	void		sizeAdjusted	() ;

	inline	QWidget	*viewport	()
	{
		return	m_scroller.viewport () ;

	}
	inline	void	addChild
		(	QWidget	*child,
			int	x,
			int	y
		)
	{
		m_scroller.addChild (child, x, y) ;
	}
	inline	void	moveChild
		(	QWidget	*child,
			int	x,
			int	y
		)
	{
		m_scroller.moveChild (child, x, y) ;
	}
	inline	void	updateContents
		(	int	x,
			int	y,
			int	w,
			int	h
		)
	{
		m_scroller.updateContents (x, y, w, h) ;
	}
	inline	int	frameWidth ()
	{
		return	m_scroller.frameWidth () ;
	}
	inline	QPoint	viewportToContents
		(	QPoint	p
		)
	{
		return	m_scroller.viewportToContents (p) ;
	}
	inline	QPoint	contentsToViewport
		(	QPoint	p
		)
	{
		return	m_scroller.contentsToViewport (p) ;
	}
	inline	QScrollView *getScroller ()
	{
		return	&m_scroller ;
	}

	inline	void	makeVisible
		(	const QRect		&rCtrl,
			QFocusEvent::Reason	reason
		)
	{
		m_scroller.makeVisible (rCtrl, reason) ;
	}

	inline	void	addMorph
		(	KBItem		*morph
		)
	{
		m_scroller.addMorph (morph) ;
	}
	inline	void	remMorph
		(	KBItem		*morph
		)
	{
		m_scroller.remMorph (morph) ;
	}

	inline	void	updateMorph
		(	KBItem		*morph,
			const QRect	&mRect
		)
	{
		m_scroller.updateMorph (morph, mRect) ;
	}
	inline	void	updateMorph
		(	KBItem		*morph,
			uint		drow
		)
	{
		m_scroller.updateMorph (morph, drow) ;
	}
	inline	void	moveTags
		(	KBDispWidget	*dispWidget,
			uint		y
		)
	{
		m_scroller.moveTags (dispWidget, y) ;
	}
}	;

#endif	// __KB_DISPSCROLLER_H
