/***************************************************************************
    file	         : kb_dispwidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DISPWIDGET
#define	__KB_DISPWIDGET

#include 	"libkbase_exports.h"

#include	<qtimer.h>
#include	<qframe.h>
#include	<qscrollbar.h>
#include	<qlist.h>
#include	<qlabel.h>

#include	"kb_classes.h"
#include	"kb_recordnav.h"
#include	"kb_attrnav.h"


/*  KBDispWidget							*/
/*  ------------							*/
/*  This is a wrapper for QWidget so that we can pick up mouse and	*/
/*  paint events and pass them up to the owning KBDisplay for possible	*/
/*  processing.								*/

class 	LIBKBASE_API	KBDispWidget : public QFrame
{
	Q_OBJECT

	KBDisplay	*m_display	;
	uint		m_showBar	;
	bool		m_inSetRange	;

	QScrollBar	*m_vBar		;
	KBRecordNav	*m_rLabel	;	/* Record count label	*/

	KB::ShowAs	m_showing	;
	QTimer		m_scrollTimer	;

	QList<KBItem>	m_morphList	;
	QPoint		m_mouseDownAt	;

	QString		m_title		;
	QString		m_tagText	;
	QLabel		*m_tagLabel	;

protected :

	virtual void	mousePressEvent		(QMouseEvent  *) ;
	virtual void	mouseMoveEvent		(QMouseEvent  *) ;
	virtual	void	mouseReleaseEvent	(QMouseEvent  *) ;
	virtual	void	paintEvent 		(QPaintEvent  *) ;
	virtual	void	resizeEvent		(QResizeEvent *) ;
	virtual	bool	event			(QEvent    *) ;

	virtual	void	mouseDoubleClickEvent	(QMouseEvent  *) ;

protected slots :

	void		vbarMoved		()	;
	void		morphDestroyed		()	;
	void		scrollTimeout		()	;
	void		slotAction		(KB::Action) ;

public	:

	KBDispWidget		(QWidget *, KBDisplay *, uint) ;
	virtual	~KBDispWidget	() ;

	void		showAs			(KB::ShowAs)	;
	void		setShowbar		(uint)		;
	void		setFrame		(int, int)	;
	void		setRowRange		(uint, uint, uint, uint, uint) ;
	QSize		effectiveSize		() ;
	void		setTitle		(const QString &) ;

	void		addMorph		(KBItem  *)	;
	void		remMorph		(KBItem  *)	;
	void		updateMorph		(KBItem  *, const QRect &) ;
	void		updateMorph		(KBItem  *, uint) ;

	void		setTagLabel		(const QString &) ;
	QLabel		*getTagLabel		(QWidget *)	;
}	;

#endif	// __KB_DISPWIDGET
