/***************************************************************************
    file	         : kb_editlistview.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#if		__KB_EMBEDDED
#include	<qpe/qpeapplication.h>
#endif

#include	<qapplication.h>
#include	<qpopupmenu.h>
#include	<qcursor.h>
#include 	<qpainter.h>

#include	"kb_classes.h"

#ifndef 	_WIN32
#include	"kb_editlistview.moc"
#else
#include	"kb_editlistview.h"
#endif


extern	QPalette *getMarkedPalette () ;


KBEditListViewItem::KBEditListViewItem
	(	KBEditListView 		*parent,
		QListViewItem		*after,
		QString			label1,
		QString			label2,
		QString			label3,
		QString			label4,
		QString			label5,
		QString			label6,
		QString			label7,
		QString			label8
	)
	:
	QListViewItem (parent, after, label1, label2, label3, label4,
				      label5, label6, label7, label8),
	m_parent      (parent)
{
}

KBEditListViewItem::KBEditListViewItem
	(	KBEditListView     	*parent,
		QString			label1,
		QString			label2,
		QString			label3,
		QString			label4,
		QString			label5,
		QString			label6,
		QString			label7,
		QString			label8
	)
	:
	QListViewItem (parent, 	      label1, label2, label3, label4,
				      label5, label6, label7, label8),
	m_parent      (parent)
{
}

KBEditListViewItem::KBEditListViewItem
	(	KBEditListView		*parent,
		QListViewItem		*after
	)
	:
	QListViewItem (parent, after),
	m_parent      (parent)
{
}

KBEditListViewItem::KBEditListViewItem
	(	KBEditListView 		*parent
	)
	:
	QListViewItem (parent),
	m_parent      (parent)
{
}

/*  KBEditListViewItem							*/
/*  paintCell	: Paint a specified cell				*/
/*  p		: QPainter *	: Painter for cell			*/
/*  cg		: QColorGroup &	: Colour group to be used		*/
/*  column	: int		: Column number				*/
/*  width	: int		: Column width				*/
/*  align	: int		: Column alignment			*/
/*  (returns)	: void		:					*/

void	KBEditListViewItem::paintCell
	(	QPainter		*p,
		const QColorGroup	&cg,
		int			column,
		int			width,
		int			align
	)
{
	if ((column == 0) && (m_parent->m_currItem == this) && m_parent->m_firstIsIndex)
	{
		QPalette *mp = getMarkedPalette () ;
		QListViewItem::paintCell (p, mp->active(), column, width, align) ;
	}
	else	QListViewItem::paintCell (p, cg, column, width, align) ;

	p->setPen   (QPen (black, 1)) ;
	p->drawRect (0, 0, width, height()) ;

	m_parent->placeOverlay (this, (uint)column) ;
}


void	KBEditListViewItem::putText
	(	int		colno,
		const QString	&text
	)
{
	m_parent->cancelEdit () ;
	setText (colno, text) ;
	m_parent->itemClicked (this, QPoint(), colno) ;
}



/*  ------------------------------------------------------------------  */

/*  NOTE								*/
/*  Because this is a flat list view we use "itemBelow()" and		*/
/*  "itemAbove()" to navigate up and down the list.			*/

/*  KBEditListView							*/
/*  KBEditListView							*/
/*		: Constructor for editable list view			*/
/*  firstIsIndex: bool		 : First column is index		*/
/*  parent	: QWidget *	 : Parent widget			*/
/*  name	: const char *	 : Widget name				*/
/*  (returns)	: KBEditListView :					*/

KBEditListView::KBEditListView
	(	bool		firstIsIndex,
		QWidget		*parent,
		const char	*name
	)
	:
	QListView	(parent, name),
	m_editor	(this),
	m_check		(this),
	m_combo		(this),
	m_firstIsIndex	(firstIsIndex)
{
	init	() ;
}

/*  KBEditListView							*/
/*		: Constructor for editable list view			*/
/*  firstIsIndex: bool		 : First column is index		*/
/*  parent	: QWidget *	 : Parent widget			*/
/*  name	: const char *	 : Widget name				*/
/*  flags	: WFlags	 : Window flags				*/
/*  (returns)	: KBEditListView :					*/

KBEditListView::KBEditListView
	(	bool		firstIsIndex,
		QWidget		*parent,
		const char	*name,
		WFlags		flags
	)
	:
	QListView	(parent, name, flags),
	m_editor	(this),
	m_check		(this),
	m_combo		(this),
	m_firstIsIndex	(firstIsIndex)
{
	init	() ;
}

/*  KBEditListView							*/
/*  init	: Initialise						*/
/*  (returns)	: void		:					*/

void	KBEditListView::init ()
{
#if	__KB_EMBEDDED
	QPEApplication::setStylusOperation
	(	this->viewport(),
		QPEApplication::RightOnHold
	)	;
#endif

	for (uint idx = 0 ; idx < MAXCOL ; idx += 1)
		m_editType[idx] = EdLineEdit ;

	setSorting	 (-1) ;
	setSelectionMode (QListView::NoSelection) ;

	m_editItem	= 0 ;
	m_popItem	= 0 ;
	m_currItem	= 0 ;

	connect
	(	&m_editor,
		SIGNAL(textChanged (const QString &)),
		SLOT  (textChanged (const QString &))
	)	;

	connect
	(	&m_check,
		SIGNAL(toggled     (bool)),
		SLOT  (checkChanged(bool))
	)	;

	connect
	(	&m_combo,
		SIGNAL(activated   (const QString &)),
		SLOT  (textChanged (const QString &))
	)	;

	connect
	(	this,
		SIGNAL(clicked    (QListViewItem *, const QPoint &, int)),
		SLOT  (itemClicked(QListViewItem *, const QPoint &, int))
	)	;

	connect
	(	this,
		SIGNAL(rightButtonPressed
				  (QListViewItem *, const QPoint &, int)),
		SLOT  (rightClick (QListViewItem *, const QPoint &, int))
	)	;


	m_editor.setFrame	    (false) ;
	m_editor.hide               ()	    ;
	m_editor.installEventFilter (this)  ;

	m_check .hide               ()	    ;
	m_check .installEventFilter (this)  ;

	m_combo .hide               ()	    ;
	m_combo .installEventFilter (this)  ;

	m_editWidget	= 0 ;
}

/*  KBEditListView							*/
/*  getRowNum	: Get row number given an item				*/
/*  item	: QListViewItem * : Item in question			*/
/*  (returns)	: uint		  : Row number				*/

uint	KBEditListView::getRowNum
	(	QListViewItem	*item
	)
{
	uint		row	= 0 ;
	QListViewItem	*lvi	= firstChild() ;

	while ((lvi != 0) && (lvi != item))
	{	row	+= 1 ;
		lvi	 = lvi->itemBelow() ;
	}

	return	row	;
}

/*  KBEditListView							*/
/*  eventFilter	: Custom event filter					*/
/*  o		: QObject *	: Object receiving event		*/
/*  e		: QEvent *	: Event in question			*/
/*  (returns)	: bool		: Event consumed			*/

bool	KBEditListView::eventFilter
	(	QObject	*o,
		QEvent	*e
	)
{
	if (o == &m_editor || o == &m_check || o == &m_combo)
		if (e->type() == QEvent::KeyPress)
		{
			QKeyEvent 	*k	= (QKeyEvent *)e ;
			int	  	key	=  k->key   ()   ;
			bool	  	shift	= (k->state () & Qt::ShiftButton) != 0 ;
			QListViewItem	*next	= m_editItem	 ;
			uint		nextCol	= m_editCol	 ;

			if (shift && (key == Qt::Key_Tab)) key = Qt::Key_Backtab ;

			if	(key == Qt::Key_Backtab)
			{
				if (m_editCol <= (m_firstIsIndex ? 1 : 0))
				{
					next	= m_editItem->itemAbove() ;
					nextCol	= columns() - 1 ;
				}
				else	nextCol	= m_editCol - 1 ;
			}
			else if (key == Qt::Key_Tab)
			{
				if (m_editCol >= (uint)columns() - 1)
				{
					next	= m_editItem->itemBelow () ;
					nextCol	= m_firstIsIndex ? 1 : 0 ;
				}
				else	nextCol	= m_editCol + 1 ;
			}
			else	return	false	;

			if (next != 0) itemClicked (next, QPoint(), nextCol) ;
			return	true	;
		}
		else	return	false	;

	return	QListView::eventFilter (o, e) ;
}

/*  KBEditListView							*/
/*  textChanged	: Text changed in edit or combo				*/
/*  text	: const QString & : new text				*/
/*  (returns)	: void		  :					*/

void	KBEditListView::textChanged
	(	const QString	&text
	)
{
	if (m_editItem != 0)
	{	m_editItem->setText (m_editCol, text) ;
		emit changed (m_editItem, m_editCol) ;
		emit changed (getRowNum (m_editItem), m_editCol) ;
	}
}

/*  KBEditListView							*/
/*  checkChanged: Checkbox state changed				*/
/*  on		: bool		: Check is on				*/
/*  (returns)	: void		  :					*/

void	KBEditListView::checkChanged
	(	bool		on
	)
{
	if (m_editItem != 0)
	{	m_editItem->setText (m_editCol, on ? "Yes" : "No") ;
		emit changed (m_editItem, m_editCol) ;
		emit changed (getRowNum (m_editItem), m_editCol) ;
	}
}

/*  KBEditListView							*/
/*  doShowZoom	: Show item zoomed					*/
/*  (returns)	: void		  :					*/

void	KBEditListView::doShowZoom ()
{
	if (m_popItem != 0)
		showZoom (m_popItem, m_popCol) ;
}

void	KBEditListView::numberRows ()
{
	if (m_firstIsIndex)
	{
		uint	idx	= 0 ;
		for (QListViewItem *item = firstChild() ; item != 0 ; item = item->itemBelow())
		{
			item->setText (0, QString("%1").arg(idx)) ;
			idx	+= 1  ;
		}
	}
}

/*  KBEditListView							*/
/*  insertRow	: Insert a new row					*/
/*  (returns)	: void		  :					*/

void	KBEditListView::insertRow ()
{
	if (m_popItem != 0)
	{
		KBEditListViewItem *item = newItem (m_popItem->itemAbove()) ;
		numberRows () ;
		emit inserted (item) ;
		emit inserted (getRowNum (item)) ;
		m_popItem = 0 ;
	}
}

/*  KBEditListView							*/
/*  deleteRow	: Delete a row						*/
/*  (returns)	: void		  :					*/

void	KBEditListView::deleteRow ()
{
	if (m_popItem != 0)
	{
		if (m_editWidget != 0)
		{
			m_editWidget->hide()	;
			m_editWidget = 0	;
			m_editItem   = 0	;
		}

		bool	last	= m_popItem->itemBelow() == 0 ;
		uint	row	= getRowNum (m_popItem) ;

		delete	m_popItem	;

		emit	deleted (m_popItem) ;
		emit	deleted (row )	;

		if (last) newItem (0)	;
		numberRows ()		;
		m_popItem = 0 		;
	}
}

void	KBEditListView::moveUp ()
{
	if ((m_popItem != 0) && (m_popItem->itemAbove() != 0))
	{
		QListViewItem *after = m_popItem->itemAbove()->itemAbove() ;

		if (after == 0)
		{
			takeItem   (m_popItem) ;
			insertItem (m_popItem) ;
		}
		else	m_popItem->moveItem (after) ;

		numberRows () ;
	}
}

void	KBEditListView::moveDown ()
{
	if ((m_popItem != 0) && (m_popItem->itemBelow() != 0))
	{
		m_popItem->moveItem (m_popItem->itemBelow()) ;
		numberRows () ;
	}
}

/*  KBEditListView							*/
/*  rightClick	: Handle mouse right click				*/
/*  item	: QListViewIte * : Item in which clicked		*/
/*		: const QPoint & : Click position			*/
/*  colno	: int		 : Column number			*/
/*  (returns)	: void		 :					*/

void	KBEditListView::rightClick
	(	QListViewItem	*item,
		const QPoint	&,
		int		colno
	)
{
	QPopupMenu	popup	;

	if (item == 0)
		return	;

	if (m_editWidget != 0)
	{
		m_editWidget->hide()	;
		m_editWidget = 0	;
		m_editItem   = 0	;
	}

	popup.insertItem ("Cancel") ;
	int	i1	= popup.insertItem (TR("&Zoom"),      this, SLOT(doShowZoom())) ;
	int	i2	= popup.insertItem (TR("&Insert"),    this, SLOT(insertRow ())) ;
	int	i3	= popup.insertItem (TR("&Delete"),    this, SLOT(deleteRow ())) ;
	int	i4	= popup.insertItem (TR("Move &up"),   this, SLOT(moveUp	   ())) ;
	int	i5	= popup.insertItem (TR("Move &down"), this, SLOT(moveDown  ())) ;
	

	if (!isZoomable (item, colno))
		popup.setItemEnabled (i1, false) ;

	/* If the first child has no next sibling then it is the one	*/
	/* and only entry and it it empty, so insert is not reasonable.	*/
	if (firstChild()->itemBelow() == 0)
		popup.setItemEnabled (i2, false) ;

	/* If this is the last element in the list (ie., the empty one	*/
	/* at the end then it cannot be deleted nor moved).		*/
	if (item->itemBelow() == 0)
	{
		popup.setItemEnabled (i3, false) ;
		popup.setItemEnabled (i4, false) ;
		popup.setItemEnabled (i5, false) ;
	}

	/* If the item is the first then it cannot be moved up.		*/
	if (item == firstChild())
		popup.setItemEnabled (i4, false) ;

	/* If this is the item before the final empty entry then it	*/
	/* cannot be moved down.					*/
	if ((item->itemBelow() != 0) && (item->itemBelow()->itemBelow() == 0))
		popup.setItemEnabled (i5, false) ;

	m_popItem = (KBEditListViewItem *)item ;
	m_popCol  = colno ;

	popup.exec(QCursor::pos()) ;
}

/*  KBEditListView							*/
/*  cancelEdit	: Cancel any outstanding edit				*/
/*  (returns)	: void		:					*/

void	KBEditListView::cancelEdit ()
{
	m_editItem = 0	;
	if (m_editWidget != 0) m_editWidget->hide () ;
}

/*  KBEditListView							*/
/*  itemClicked	: User clicks inside an item				*/
/*  item	: QListViewItem * : The item				*/
/*  pos		: const QPoint &  : Click position			*/
/*  col		: int		  : Column number			*/
/*  (returns)	: void		  :					*/

void	KBEditListView::itemClicked
	(	QListViewItem	*item,
		const QPoint	&pos,
		int		col
	)
{
	if (item == 0)
		return	;

	/* Any current edit widget is hidden, but whatever is clicked,	*/
	/* ignore the click if the item and column is not editable.	*/
	cancelEdit () ;
	if (!isEditable (item, col))
	{
		KBEditListViewItem *oldItem = m_currItem ;
		m_currItem = (KBEditListViewItem *)item	 ;
		repaintItem (m_currItem) ;
		if (oldItem != 0) repaintItem (oldItem)  ;
		return ;
	}

	/* OK, going to edit. If this is the last row then add a new	*/
	/* one. Hence, the user can work down a list adding new rows.	*/
	if (item->itemBelow() == 0)
	{
		QListViewItem	*ptr	= firstChild() ;
		uint		cnt	= 1 ;

		while ((ptr != 0) && (ptr != item))
		{	ptr	= ptr->itemBelow() ;
			cnt    += 1 ;
		}

		newItem	(item, m_firstIsIndex ? QString("%1").arg(cnt) : QString("")) ;
	}


	/* See if a particular edit type is specified for the column.	*/
	/* If the column is not in range then use the default line edit	*/
	switch (col < MAXCOL ? m_editType[col] : EdLineEdit)
	{
		case EdCheckBox :
			m_editWidget = &m_check  ;
			m_check  .setChecked (item->text(col) == "Yes") ;
			break	;

		case EdComboBox :
			m_editWidget = &m_combo  ;
			fillCombo (m_combo, col, item->text(col)) ;
			break	;

		default	:
			m_editWidget = &m_editor ;
			m_editor.setText (item->text(col)) ;
			break	;
	}

	m_editItem = (KBEditListViewItem *)item  ;
	m_editCol  = col ;

	m_editWidget->show       () ;
	m_editWidget->setEnabled (true) ;
	m_editWidget->setFocus   () ;

	KBEditListViewItem *oldItem = m_currItem ;
	m_currItem = m_editItem  ;
	repaintItem (m_currItem) ;
	if (oldItem != 0) repaintItem (oldItem)  ;

	/* If the widget is the text editor then pass the mouse event	*/
	/* down so that the cursor ends up at the appropriate position.	*/
	if (m_editWidget == &m_editor)
	{	
		QPoint	    p = m_editor.mapFromGlobal (pos) ;
		QMouseEvent e1 (QEvent::MouseButtonPress,   p, LeftButton, LeftButton) ;
		QMouseEvent e2 (QEvent::MouseButtonRelease, p, LeftButton, LeftButton) ;
		qApp->sendEvent (&m_editor, &e1) ;
		qApp->sendEvent (&m_editor, &e2) ;
	}

	// if (m_editWidget == &m_combo)
	//	m_combo.showPopup() ;
}

/*  KBEditListView							*/
/*  placeOverlay: Position the edit overlay				*/
/*  item	: KBEditListViewItem *	: Item being painted		*/
/*  col		: uint			: Column being painted		*/
/*  (returns)	: void			:				*/

void	KBEditListView::placeOverlay
	(	KBEditListViewItem	*item,
		uint			col
	)
{
	if ((item == m_editItem) && (col == m_editCol))
	{
		int	offset	= 0 ;
		QRect	irect	= itemRect (m_editItem) ;
		int	cTop	= viewportToContents(irect.topLeft()).y() ;

		for (uint idx = 0 ; idx < m_editCol ; idx += 1)
			offset	+= columnWidth (idx) ;

		QRect	thisRect
			(	offset,
				cTop,
				columnWidth (m_editCol),
				irect.height()
			)	;

		moveChild (m_editWidget, thisRect.left(),  thisRect.top()) ;
		m_editWidget->resize (thisRect.width(), thisRect.height()) ;

		// m_currRect = thisRect ;
	}
}

/*  KBEditListView							*/
/*  setEditType	: Set column edit type					*/
/*  colno	: uint		: Column number				*/
/*  type	: EdType	: Edit type for column			*/
/*  (returns)	: void		:					*/

void	KBEditListView::setEditType
	(	uint	colno,
		EdType	type
	)
{
	if (colno < MAXCOL) m_editType[colno] = type ;
}

/*  KBEditListView							*/
/*  fillCombo	: Fill combo box values					*/
/*  comboBox	: QComboBox &	  : Combobox in question		*/
/*  colNo	: uint		  : Column number			*/
/*  curVal	: const QSTring & : Column text value			*/
/*  (returns)	: void		  :					*/

void	KBEditListView::fillCombo
	(	QComboBox	&comboBox,
		uint		,
		const QString	&
	)
{
	/* Basically do nothing. Where comboboxes are used a derived	*/
	/* class should implement this method.				*/
	comboBox.clear () ;
}

/*  KBEditListView							*/
/*  isEditable	: Check if item and column can be edited		*/
/*  item	: QListViewItem * : Item in question			*/
/*  col		: uint		  : Column in question			*/
/*  (returns)	: bool		  : Is editable				*/

bool	KBEditListView::isEditable
	(	QListViewItem	*,
		uint		col
	)
{
	if (m_firstIsIndex && (col == 0)) return false ;
	return	true	;
}

/*  KBEditListView							*/
/*  isZoomable	: Check if item and column can be zoomed		*/
/*  item	: QListViewItem * : Item in question			*/
/*  col		: uint		  : Column in question			*/
/*  (returns)	: bool		  : Is zoomable				*/

bool	KBEditListView::isZoomable
	(	QListViewItem	*,
		uint
	)
{
	/* Default is false. May be overridden by derived classes.	*/
	return	false	;
}

/*  KBEditListView							*/
/*  showZoom	: Show item zoomed					*/
/*  item	: QListViewItem * : Item in question			*/
/*  col		: uint		  : Column in question			*/
/*  (returns)	: void		  :					*/

void	KBEditListView::showZoom
	(	QListViewItem	*,
		uint
	)
{
	/* Default is noop. May be overridden by derived classes.	*/
}

KBEditListViewItem
	*KBEditListView::newItem
	(	QListViewItem	*after,
		QString		label1
	)
{
	/* Override this method to allocate imlementation specific	*/
	/* item instances.						*/
	return	new KBEditListViewItem (this, after, label1) ;
}
