/***************************************************************************
    file	         : kb_grid.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_GRID_H
#define	_KB_GRID_H

#include	"libkbase_exports.h"

#include	<qintdict.h>

#include	"kb_classes.h"
#include	"kb_object.h"
#include	"kb_qtgrid.h"



/*  KBGrid								*/
/*  ------								*/
/*  This class is used for XML parse tree elements corresponding to	*/
/*  headers used in grid blocks.					*/

class LIBKBASE_API	KBGrid : public KBObject
{
	Q_OBJECT

	KBAttrBool	m_nosort	;

	KBCtrlGrid	*m_grid		;
	QList<KBItem>	m_allItems	;
	QList<KBItem>	m_visItems	;
	int		m_sortCol	;
	bool		m_sortAsc	;

	QIntDict<KBItem>m_defTabOrder	;

	void			adjustItems	(int) 	;

protected :

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar  *)		;
#endif

public	:

	KBGrid	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBGrid	(KBNode  *, KBGrid *) ;
virtual~KBGrid	()		 ;

	virtual	KBNode		*replicate	(KBNode *) ;

	virtual	KBGrid		*isGrid		() { return this ; }

	virtual	void		buildCtrls	(uint, int, int )	;
	virtual	void		showAs		(KB::ShowAs)		;

	void			getItems	(QList<KBItem>    &)	;
	void			setOrder	(QList<KBItem>    &)	;
	void			setItemsVisible	(QValueList<bool> &, bool = false) ;
	void			setItemsEnabled	(QValueList<bool> &)	;

	void			setColumnWidth	(KBItem *,  uint)	;

	void			clearItems	(bool = false)		;
	void			appendItem	(KBItem *, bool = false);
	void			resetSort	()			;
	void			orderByExpr	(bool)			;
	void			columnSort	()			;

public slots	:

	void			sizeChange	(int, int, int)	;
	void			indexChange	(int, int, int)	;
	void			columnClicked	(int)		;
}	;

#endif	// _KB_GRID_H
