/***************************************************************************
    file	         : kb_itemdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>
#include	<qregexp.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_qrybase.h"
#include	"kb_block.h"
#include	"kb_item.h"
#include	"kb_select.h"


#ifndef 	_WIN32
#include 	"kb_itemdlg.moc"
#else
#include 	"kb_itemdlg.h"
#endif




/*  KBItemPropDlg							*/
/*  KBItemPropDlg: Constructor for item properties dialog		*/
/*  item	 : KBItem *	  : Parent item				*/
/*  caption	 : const char *   : Dialog box caption			*/
/*  attribs	 : QList<KBAttr>& : List of attributes			*/
/*  apply	 : bool		  : Show apply button			*/
/*  iniAttr	 : cchar *	  : Initial attribute			*/
/*  (returns)	 : KBItemPropDlg  :					*/

KBItemPropDlg::KBItemPropDlg
	(	KBItem		*item,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBPropDlg (item, caption, attribs, iniAttr),
	m_item	  (item)
{
	m_fldList.setAutoDelete (true) ;
}

/*  KBItemPropDlg							*/
/*  ~KBItemPropDlg: Destructor for item properties dialog		*/
/*  (returns)	   : void	:					*/

KBItemPropDlg::~KBItemPropDlg ()
{
}

/*  KBBItemPropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem
	*KBItemPropDlg::getAttrItem
	(	KBAttr	*attr
	)
{
	return	KBPropDlg::getAttrItem (attr) ;
}

/*  KBItemPropDlg							*/
/*  getBlockQuery: Get associated query from the owning block		*/
/*  qlvl	 : uint &	: Query level				*/
/*  (returns)	 : KBQryBase *	: Query or null on error		*/

KBQryBase
	*KBItemPropDlg::getBlockQuery
	(	uint	&qlvl
	)
{
	KBBlock    *block  ;
	KBQryBase  *query  ;

	if ((block = m_item ->getBlock()) == 0)
	{	warning	(TR("Failed to get parent block")) ;
		return	0 ;
	}

	if ((query = block->getQuery ()) == 0)
	{	warning (TR("Failed to locate parent query")) ;
		return	0 ;
	}

	qlvl	= block->getQryLevel () ;
	return	query	;
}

/*  KBItemPropDlg							*/
/*  loadFieldList							*/
/*		: Load field list into combo box			*/
/*  query	: KBQryBase *	  : Query in question			*/
/*  qlvl	: uint		  : Query level				*/
/*  combo	: QComboBox *	  : Combo box to load			*/
/*  value	: const QString & : Current setting			*/
/*  addNull	: bool		  : Add a null entry			*/
/*  (returns)	: bool		  : Success				*/

bool	KBItemPropDlg::loadFieldList
	(	KBQryBase	*query,
		uint		qlvl,
		QComboBox	*combo,
		const QString	&value,
		bool		addNull
	)
{
	int	at	= -1 ;
	int	pKey    ;

	m_fldList.clear () ;

	if (!query->getFieldList (qlvl, m_fldList, pKey))
	{
		query->lastError().DISPLAY() ;
		return	false	;
	}

	if (addNull)
	{
		combo->insertItem ("") ;
		if (value.isEmpty()) at = 0 ;
	}

	for (uint idx = 0 ; idx < m_fldList.count() ; idx += 1)
	{
		if (m_fldList.at(idx)->m_name == value)
			at = combo->count() ;

		combo->insertItem (m_fldList.at(idx)->m_name) ;

	}

	if (at >= 0) combo->setCurrentItem (at) ;

	return	true	;
}


/*  KBItemPropDlg							*/
/*  showQueryField							*/
/*		: Show query fields as prompt for text input		*/
/*  query	: KBQryBase *	  : Query in question			*/
/*  qlvl	: uint		  : Query level				*/
/*  value	: const QString & : Current setting			*/
/*  (returns)	: bool		  : Success				*/

bool	KBItemPropDlg::showQueryField
	(	KBQryBase	*query,
		uint		qlvl,
		const QString	&value
	)
{
	if (!loadFieldList (query, qlvl, &comboBox, value, false))
		return	false	;

	editBox .show		   () ;
	comboBox.show		   () ;
	editBox .insert	 	   (value) ;
	editBox .setFocus    	   () ;
	editBox .setCursorPosition (0xffff, 0xffff) ;

	connect
	(	&comboBox,
		SIGNAL (activated(const QString &)),
		SLOT   (pickCombo(const QString &))
	)	;

	return	true ;
}

/*  KBItemPropDlg							*/
/*  pickQueryField							*/
/*		: Show query fields for picking				*/
/*  query	: KBQryBase *	: Query in question			*/
/*  qlvl	: uint		: Query level				*/
/*  value	: cchar *	: Current setting			*/
/*  addNull	: bool		: Add a null entry			*/
/*  combo	: QComboBox *	: Caller combo box			*/
/*  (returns)	: bool		: Success				*/

bool	KBItemPropDlg::pickQueryField
	(	KBQryBase	*query,
		uint		qlvl,
		const QString	&value,
		bool		addNull,
		QComboBox	*combo
	)
{
	if (combo == 0)
		combo = &comboBox ;

	if (!loadFieldList (query, qlvl, combo, value, addNull))
		return	false	;

	combo->show () ;
	return	true   ;
}

/*  KBItemPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBItemPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName () ;

	/* Field name/Expression					*/
	/* For convenience, we show a list of all fields associated	*/
	/* with the owning block's query.				*/
	if ((aName == "name") || (aName == "expr") || (aName == "master")) 
	{
		KBQryBase	*query	;
		uint		qlvl	;
		if ((query = getBlockQuery (qlvl)) == 0) return false ;
		return	showQueryField (query, qlvl, item->value()) ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBItemPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Field name							*/
	/* Copy the result back ....					*/
	if (aName == "name")
	{
		if (strcmp (editBox.text(), item->value()) != 0)
			setProperty (item, editBox.text()) ;

		return	true ;
	}

	/* Expression							*/
	/* Copy result back, also set "nullok" property (if present) as	*/
	/* appropriate if the expression is a field in the table.	*/
	if ((aName == "expr") || (aName == "master")) 
	{
		QString	value	= editBox.text() ;

		if (!KBSelect::singleExpression (value))
		{
			KBError::EError
			(	QString (TR("Expressions may not contain multiple columns, please edit")),
				value,
				__ERRLOCN
				)	;
			return	false	;
		}

		if (value == item->value())
			return	true	;

		setProperty (item, value) ;

		for (uint idx = 0 ; idx < m_fldList.count() ; idx += 1)
			if (m_fldList.at(idx)->m_name == value)
			{
				setProperty
				(	"nullok", 
					(m_fldList.at(idx)->m_flags & KBFieldSpec::NotNull) != 0 ? "No" : "Yes"
				)	;

				break	;
			}

		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}
