/***************************************************************************
    file	         : kb_listview.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	"kb_listview.h"

static	void	countSelected
	(	QListViewItem	*item,
		int		limit,
		int		&count
	)
{
	if ((item != 0) && (count < limit))
	{
		if (item->isSelected()) count += 1 ;
		if (count >= limit) return ;

		for (QListViewItem *child  = item ->firstChild  () ;
				    child != 0 ;
				    child  = child->nextSibling ())
		{
			::countSelected (child, limit, count) ;
			if (count >= limit) break ;
		}
	}
}

static	void	getSelection
	(	QListViewItem		*item,
		QList<QListViewItem>	&list
	)
{
	if (item != 0)
	{
		if (item->isSelected()) list.append (item) ;

		for (QListViewItem *child  = item ->firstChild  () ;
				    child != 0 ;
				    child  = child->nextSibling ())
			::getSelection (child, list) ;
	}
}

void	KBListView::contentsMouseReleaseEvent
	(	QMouseEvent *event
	)
{
	state	= event->state () ;
	type	= QEvent::MouseButtonRelease ;
	QListView::contentsMouseReleaseEvent (event) ;
}

void	KBListView::contentsMouseDoubleClickEvent
	(	QMouseEvent *event
	)
{
	state	= event->state () ;
	type	= QEvent::MouseButtonDblClick ;
	QListView::contentsMouseDoubleClickEvent (event) ;
}

void	KBListView::keyPressEvent
	(	QKeyEvent   *event
	)
{
	state	= event->state  () ;
	type	= QEvent::KeyPress ;
	QListView::keyPressEvent (event) ;
}

bool	KBListView::anySelected ()
{
	int	count = 0 ;
	::countSelected (firstChild(), 1, count) ;
	return	count > 0 ;
}

int	KBListView::someSelected
	(	int	limit
	)
{
	int	count = 0 ;
	::countSelected (firstChild(), limit, count) ;
	return	count	  ;
}

int	KBListView::countSelected ()
{
	int	count = 0 ;
	::countSelected (firstChild(), 0x7fffffff, count) ;
	return	count 	  ;
}

QList<QListViewItem>
	KBListView::getSelection ()
{
	QList<QListViewItem> list ;
	::getSelection (firstChild(), list) ;
	return	list	;
}

void	KBListView::setOpen
	(	QListViewItem	*item,
		bool		open
	)
{
	if (type != QEvent::MouseButtonDblClick)
	{	QListView::setOpen (item, open) ;
		return	;
	}

	type	= QEvent::None	;
}

void	KBListView::setSelected
	(	QListViewItem	*item,
		bool		select
	)
{
	selecting = true  ;
	QListView::setSelected (item, select) ;
	selecting = false ;
}
