/***************************************************************************
    file	         : kb_macrodef.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qdir.h>
#include	<qdict.h>

#include	"kb_classes.h"
#include	"kb_macrodef.h"
#include	"kb_locator.h"


#define	DOMITER_BEGIN(root,tag,child)	\
	{										\
	for (QDomNode n = root.firstChild() ; !n.isNull() ; n = n.nextSibling())	\
	{	QDomElement child = n.toElement() ;					\
		if (child.tagName() != tag) continue ;

#define	DOMITER_END	\
	}		\
	}


static	QStringList		macroNames	;
static	QDict<KBMacroDef>	macroDictionary	;



/*  KBMacroArgDef							*/
/*  KBMacroArgDef: Constructor for macro argument definition object	*/
/*  (returns)	 : KBMacroArgDef :					*/

KBMacroArgDef::KBMacroArgDef ()
{
}

/*  KBMacroArgDef							*/
/*  KBMacroArgDef: Constructor for macro argument definition object	*/
/*  element	 : QDomElement & : Definition element			*/
/*  (returns)	 : KBMacroArgDef :					*/

KBMacroArgDef::KBMacroArgDef
	(	QDomElement	&element
	)
{
	m_type	= element.attribute("type"  ) ;
	m_arg	= element.attribute("legend") ;

	DOMITER_BEGIN(element,"choice",choice)
	{
		m_choices.append (choice.attribute("value")) ;
	}
	DOMITER_END
}


/*  KBMacroDef								*/
/*  KBMacroDef	: Constructor for macro definition object		*/
/*  element	: QDomElement &	: Definition element			*/
/*  (returns)	: KBMacroDef	:					*/

KBMacroDef::KBMacroDef
	(	QDomElement	&element
	)
{
	m_name	= element.attribute("name") ;
	m_blurb	= element.text() ;

	DOMITER_BEGIN(element,"arg",arg)
	{
		m_args.append (KBMacroArgDef(arg)) ;
	}
	DOMITER_END
}

/*  KBMacroDef								*/
/*  loadMacroDefs: Load macro definitions				*/
/*  (returns)	 : void		:					*/

void	KBMacroDef::loadMacroDefs ()
{
	/* This is only done once, so check to see if there are any	*/
	/* definitions, in which case we can return.			*/
	if (macroDictionary.count() > 0)
		return	;


	/* Macro definition files are stored in the "dict" directory	*/
	/* with the extension ".mac". Locate the directory and loop	*/
	/* over all the definition files found there.			*/
	QString	dPath	;
	QDir	dDir	;

#ifndef _WIN32
	dPath	= locateDir ("appdata", "dict/rekall.dict" ) + "/dict"  ;
#else
	dPath	= locateDir ("appdata", "dict\\rekall.dict") + "\\dict" ;
#endif

	dDir.setPath	   (dPath) ;
	dDir.setNameFilter ("*.mac") ;
	dDir.setFilter     (QDir::Files|QDir::Readable) ;

	const QFileInfoList   *info = dDir.entryInfoList() ;
	if (info == 0)
	{
		fprintf	(stderr, "No macro specifications found!!\n") ;
		return	;
	}

	QFileInfoListIterator dIter (*info) ;
	QFileInfo *fi ;

	while ((fi = dIter.current()) != 0)
	{
		QString	name = fi->filePath() ;
		dIter += 1 ;

		fprintf
		(	stderr,
			"Found macro file [%s]\n",
			(cchar *)name
		)	;

		/* Open the file for reading. Should not fail since we	*/
		/* have selected readable files, but check just in case	*/
		QFile srce(name) ;
		if (!srce.open (IO_ReadOnly))
		{
			fprintf
			(	stderr,
				"Macro file [%s]: cannot open\n",
				(cchar *)name
			)	;
			continue;
		}

		/* Create a new DOM document and set the file as the	*/
		/* document contents. If this fails grumble and ignore	*/
		/* the document.					*/
		QDomDocument	dom ;
		if (!dom.setContent (&srce))
		{
			fprintf
			(	stderr,
				"Macro file [%s]: cannot parse\n",
				(cchar *)name
			)	;
			continue	;
		}

		/* Loop over all top-level "macro" elements, each of	*/
		/* which is a definition. Store pointers to these in	*/
		/* the dictionary under the macro name.			*/
		QDomElement root = dom.documentElement() ;
		DOMITER_BEGIN(root,"macro",macro)
		{
			QString	name = macro.attribute("name") ;
			macroDictionary.insert (name, new KBMacroDef (macro)) ;
			macroNames     .append (name) ;
		}
		DOMITER_END
	}
}


/*  KBMacroDef								*/
/*  getMacroNames: Get list of macro names				*/
/*  (returns)	 : const QStringList & : List				*/

const QStringList
	&KBMacroDef::getMacroNames ()
{
	loadMacroDefs   () ;
	return	macroNames ;
}

/*  KBMacroDef								*/
/*  getMacroDef	: Get definition of named macro				*/
/*  name	: const QString & : Name				*/
/*  (returns)	: KBMacroDef *	  : Definition or null if not known	*/

KBMacroDef
	*KBMacroDef::getMacroDef
	(	const QString	&name
	)
{
	loadMacroDefs () ;
	return	macroDictionary.find (name) ;
}
