/***************************************************************************
    file	         : kb_param.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdarg.h>

#include	<qlist.h>
#include	<qdict.h>
#include	<qstring.h>
#include	<qmessagebox.h>
#include	<qpopupmenu.h>


#include	"kb_classes.h"
#include	"kb_attr.h"

#include	"kb_node.h"
#include	"kb_object.h"
#include	"kb_param.h"
#include	"kb_paramsetdlg.h"
#include	"kb_nodereg.h"


QString	paramSub
	(	const QString		&value,
		const QDict<QString>	&paramDict
	)
{
	if (value.isNull() || (value.find ("${") < 0))
		return value ;

	QString	res	= "" 	;
	int	pos1	= 0	;
	int	pos2	;

	while ((pos2 = value.find ("${", pos1)) >= 0)
	{
		res	+= value.mid (pos1, pos2 - pos1) ;
		pos1	 = pos2 + 2 ;

		if ((pos2 = value.find ("}", pos1)) < 0)
		{	res	+= "${" ;
			break	;
		}

		QString		param	= value.mid (pos1, pos2 - pos1) ;
		QStringList	bits	= QStringList::split (':', param) ;
		QString		*val	= paramDict.find (bits[0]) ;

		if	(val 	      != 0) res	+= *val		;
		else if (bits.count()  > 1) res += bits[1]	;

		pos1	 = pos2 + 1 ;
	}

	res	+= value.mid (pos1) ;
	return	res ;
}



/*  KBParam								*/
/*  KBParam	: Constructor for parameter node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: Attribute list			*/
/*		: bool *	:					*/
/*  (returns)	: KBParam	:					*/

KBParam::KBParam
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBNode		(parent, "KBParam"),
	m_name		(this,	 "name",	aList),
	m_defval	(this,	 "defval",	aList),
	m_legend	(this,	 "legend",	aList),
	m_format	(this,	 "format",	aList),
	m_prompt	(this,	 "prompt",	aList)
{
	m_value	= m_defval.getValue () ;
}

/*  KBParam								*/
/*  KBParam	: Constructor for parameter node			*/
/*  parent	: KBNode *	  : Parent node				*/
/*  name	: const QString & : Name				*/
/*  defval	: const QString & : Default value			*/
/*  legend	: const QString & : Legend				*/
/*  format	: const QString & : format setting			*/
/*  prompt	: bool		  : Prompt always			*/
/*  (returns)	: KBParam	  :					*/

KBParam::KBParam
	(	KBNode			*parent,
		const QString		&name,
		const QString		&defval,
		const QString		&legend,
		const QString		&format,
		bool			prompt
	)
	:
	KBNode		(parent, "KBParam"),
	m_name		(this,	 "name",	name  ),
	m_defval	(this,	 "defval",	defval),
	m_legend	(this,	 "legend",	legend),
	m_format	(this,	 "format",	format),
	m_prompt	(this,	 "prompt",	prompt)
{
	m_value	= m_defval.getValue () ;
}

/*  KBParam								*/
/*  KBParam	: Constructor for parameter node			*/
/*  parent	: KBNode *	  : Parent node				*/
/*  extant	: KBParam *	  : Extant parameter			*/
/*  (returns)	: KBParam	  :					*/

KBParam::KBParam
	(	KBNode		*parent,
		KBParam		*extant
	)
	:
	KBNode		(parent, "KBParam"),
	m_name		(this,	 "name",	extant),
	m_defval	(this,	 "defval",	extant),
	m_legend	(this,	 "legend",	extant),
	m_format	(this,	 "format",	extant),
	m_prompt	(this,	 "prompt",	extant)
{
	m_value	= m_defval.getValue () ;
}

/*  KBParam								*/
/*  KBParam	: Destructor for parameter node				*/
/*  (returns)	:		:					*/

KBParam::~KBParam ()
{
}

/*  KBParam								*/
/*  findAllParams: Locate all paramaters in document			*/
/*  paramSet	 : QDict<KBParamSet> &  : Dictionary of found entries	*/
/*  (returns)	 : void			:				*/

void	KBParam::findAllParams
	(	QDict<KBParamSet>	&paramSet
	)
{
	paramSet.insert
	(	m_name.getValue(),
		new KBParamSet
		(	m_legend .getValue	(),
			m_defval .getValue	(),
			m_value,
			m_format .getValue	(),
			m_prompt .getBoolValue	()
		)
	)	;
}

/*  KBParam								*/
/*  replicate	: Replicate this parameter				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New choice node			*/

KBNode	*KBParam::replicate
	(	KBNode	*_parent
	)
{
	return	new KBParam (_parent, this) ;
}

NEWNODE(Param, (cchar *)0, KF_FORM|KF_REPORT)
