/***************************************************************************
    file	         : kb_propdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PROPDLG_H
#define	_KB_PROPDLG_H

#if	! __KB_RUNTIME

#include	<qlabel.h>
#include	<qlist.h>
#include	<qlistbox.h>
#include	<qcombobox.h>
#include	<qlistview.h>
#include	<qcheckbox.h>
#include	<qpushbutton.h>
#include	<qmultilinedit.h>
#include	<qcombobox.h>
#include	<qspinbox.h>
#include	<qtextview.h>


#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_resizewidget.h"
#include	"kb_conductor.h"
#include	"kb_attritem.h"
#include	"kb_attrdlg.h"

#include	"kb_config.h"
#include	"kb_configdlg.h"

#include	"tktextmanager.h"
#include	"tktexteditor.h"
#include	"tkc_tkemapper.h"

#include	"libkbase_exports.h"

struct	LIBKBASE_API	HelpMap
{
	cchar	*name	;		/* Actual attrbute name		*/
	cchar	*help	;		/* Tag used for help file	*/
}	;


class	KBSlotListDlg	;

/*  KBAttrIntChoice							*/
/*  ---------------							*/
/*  Derived attribute item used to handle choices, so that the choice	*/
/*  text rather than the numerical representation is shown.		*/

class	LIBKBASE_API	KBAttrIntChoice : public KBAttrItem
{
	IntChoice	*choices	;
	int		defval		;

public	:


	KBAttrIntChoice	(KBAttr *, IntChoice *, int = 0) ;
	virtual ~KBAttrIntChoice ()	;

	virtual	QString	displayValue	() ;
}	;


/*  KBPropDlg								*/
/*  ---------								*/
/*  This is a general-purpose control properties dialog for displaying	*/
/*  and setting properties associated with objects such as fields and	*/
/*  push-buttons.							*/

class	LIBKBASE_API	KBPropDlg : public _KBDialog, protected KBPlayer
{
	Q_OBJECT

	KBNode			*node		;
	QRect			pRect		;
	QRect			gRect		;
	KBAttrItem		*xmodeItem	;
	KBAttrItem		*ymodeItem	;
	QString			caption		;

	QIntDict<QListViewItem>	m_groups	;
	KBConfigDlg		*m_configDlg 	;

	virtual	bool		eventFilter	(QObject *, QEvent *) 	;
	QString			getHelpTag	(KBAttrItem *)		;
	void			setHelpEnabled	(KBAttrItem *) 		;
	void			positionCtrls	()			;
	uint			editLeftSide	()			;

protected :

	virtual	bool		playerPerform	(const QString &, const QStringList &, KBError &) ;
	virtual	QString		playerName	() ;

	virtual	cchar		*findHelpMapping(const QString &)	;

	virtual	void		mouseDoubleClickEvent (QMouseEvent *)	;

	QVBoxLayout		topLayout	;
	QGridLayout		butLayout	;
	KBResizeWidget		topWidget	;

private	:

	QListView		propAllVal	;

	QTextView		descrip		;
	QWidget			*userWidget	;

	KBAttrDlg		*attrDlg	;

private :

	QPushButton		bOK		;
	QPushButton		bCancel		;
	QPushButton		bAccept		;
	QPushButton		bIgnore		;
	QPushButton		bClear		;
	QPushButton		bEdit		;

protected :

	QPushButton		bVerify		;
	QPushButton		bHelp		;

private	:

	QDict<KBAttrItem>	attrByName	;
	QDict<KBAttrItem>	attrByLegend	;
	QList<KBAttr>		&attribs	;
	KBAttrItem		*curAttrItem	;
	QListViewItem		*curListItem	;
	KBAttrItem		*clrAttrItem	;
	QString			resultVal	;
	QString			iniattr		;
	QList<KBSlot>		m_slotList	;
	KBSlotListDlg		*m_slotListDlg	;

	bool			iniRSize	;
	int			width		;
	int			height		;

	void		setupListView	(QListView  &, bool) ;
	void		addAttrib	(KBAttrItem *, QListView &) ;
	void		addAttrib	(KBAttr     *)  ;

protected :


	QMultiLineEdit		editBox		;
	TKTextEditor		tkEditor	;
	TKCTKEMapper		mapper		;
	QComboBox		comboBox	;
	QCheckBox		checkBox	;
	QSpinBox		spinBox		;

	virtual	void		setSizes	()	;
	virtual	void		resizeEvent	(QResizeEvent *) ;

	virtual KBAttrItem	*getAttrItem	(KBAttr *) ;

	virtual	void		dropProperty	()	   ;
	virtual	bool		showProperty	(KBAttrItem *) ;
	virtual	bool		saveProperty	(KBAttrItem *) ;
	virtual	bool		hideProperty	(KBAttr     *) ;
	virtual	bool		propertyOK	(KBAttrItem *) ;
	virtual	void		preExec		() ;

	void			setUserWidget	(QWidget *) ;
	bool			setProperty	(KBAttrItem *, const QString &) ;
	bool			setProperty	(cchar  *,     const QString &) ;
	const QString		&getProperty	(cchar  *) ;
	bool			warning		(cchar  *) ;

	void			showChoices	(KBAttrItem *, IntChoice *, const QString &, QComboBox * = 0) ;
	void			saveChoices	(KBAttrItem *, IntChoice *, QComboBox * = 0) ;

private slots :

	void			clickClear	()	 		;
	void			clickHelp	()	 		;
	void			clickIgnore	()	 		;
	bool			clickAccept	()	 		;
	void			clickEdit	()	 		;

	virtual	void		clickVerify	()	 		;

	void			pickProperty	(QListViewItem *)	;
	void			pickCombo	(const QString &)	;
	void			setCurrent	(QListViewItem *)	;

	void			resized		(KBResizeWidget *, QSize) ;

protected slots :

	virtual	void		clickOK		() ;
	virtual	void		clickCancel	() ;

public	:

	KBPropDlg (KBNode *, cchar *, QList<KBAttr> &, cchar * = 0) ;
       ~KBPropDlg () ;

	bool			exec 		() ;
}	;

#endif

#endif	// _KB_PROPDLG_H
