/***************************************************************************
    file	         : kb_qrybase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QRYBASE_H
#define	_KB_QRYBASE_H

#include	"kb_node.h"
#include	"kb_dblink.h"
#include	"kb_dbinfo.h"
#include	"kb_select.h"

#include	"libkbase_exports.h"


/*  KBQryBase								*/
/*  ---------								*/
/*  This is a virtual base class for the KBQryData and KBQryDesign	*/
/*  classes, and is used to provide a common interface for the class	*/
/*  KBBlock.								*/

class	LIBKBASE_API	KBQryBase : public KBNode
{
	Q_OBJECT

protected :

	KBDBLink	dbLink		;

	void	    	dropServer ()	;
	bool	    	linkServer (const QString &)	;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg  	()	= 0 ;
#endif

public	:

	enum	Locking
	{
		NoLocking	= 0,
		LockRowUpdate	= 1
	}	;

		KBQryBase (KBNode *, const QDict<QString> &, cchar *) ;
		KBQryBase (KBNode *, cchar     *) ;
		KBQryBase (KBNode *, KBQryBase *) ;
	virtual~KBQryBase () ;

	virtual	KBQryBase	*isQryBase   	() { return this ;  }
	virtual	KBQryData	*isQryData   	() { return 0    ;  }
	virtual	KBQryNull	*isQryNull   	() { return 0    ;  }

	virtual	bool		addItem      	(uint, KBItem  *) = 0 ;
	virtual	void		remItem      	(uint, KBItem  *) = 0 ;
	virtual	bool		loadItems    	(uint, uint)      = 0 ;
	virtual	bool		clearItems    	(uint, uint)      = 0 ;
	virtual	void		resetData	(uint, uint)      = 0 ;

	virtual	bool		getSelect	(uint, KBSelect &)= 0 ;

	virtual	bool		select       	(uint, KBValue *,
						    const QString &,
						    const QString &,
						    const QString &,
						    bool = false, uint = 0) = 0 ;

	virtual	bool		startUpdate	(uint, uint, Locking) = 0 ;
	virtual	bool		endUpdate	(uint, bool) = 0 ;
	virtual	KBQryBase::Locking
				lockingState	(uint)	     = 0 ;

	virtual	bool		saveRow      	(uint, uint) = 0 ;
	virtual	bool		deleteRow    	(uint, uint) = 0 ;
	virtual	bool		insertRow    	(uint, uint) = 0 ;
	virtual	bool		syncRow	     	(uint, uint, KBValue *, const QString &, KBBlock *, KB::Action &, KBValue &) = 0 ;
	virtual	bool		syncAll	     	(uint,	     KBValue *, const QString &, KBBlock *) = 0 ;

	virtual	bool		newRowEmpty  	(uint, uint)		= 0 ;
	virtual	bool		rowIsDirty   	(uint, uint, bool) 	= 0 ;
	virtual	KB::RState	getRowState  	(uint, uint)		= 0 ;
	virtual	KBValue		getField     	(uint, uint, uint, bool = false   ) = 0 ;
	virtual	void		setField     	(uint, uint, uint, const KBValue &) = 0 ;
	virtual uint		getNumRows   	(uint) 			= 0 ;
	virtual	uint		setCurrentRow	(uint, uint)		= 0 ;
	virtual	uint		getWidth	(uint, uint)		= 0 ;
	virtual	uint		getPermission	(uint)			= 0 ;
	virtual	void		sortByColumn 	(uint, uint, bool, KBItem *) 	    = 0 ;

	virtual void		setRowMarked	(uint, uint, KB::MarkOp)= 0 ;
	virtual	bool		getRowMarked	(uint, uint) 		= 0 ;
	virtual	bool		deleteAllMarked	(uint, uint &)		= 0 ;

	virtual	bool		getFieldList 	(uint, QList<KBFieldSpec> &, int &) = 0 ;

	virtual	QString		getComment	(uint)		= 0 ;
	virtual	QString		getSQLText	(uint, bool)	= 0 ;
	virtual	QString		getSQLReason	(uint)		= 0 ;

	friend	class		KBBlock		;
	friend	class		KBLink		;
	friend	class		KBBlockPropDlg	;
	friend	class		KBLinkPropDlg	;
}	;

#endif	// _KB_QRYBASE_H
