/***************************************************************************
    file	         : kb_qryexpr.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QRYEXPR_H
#define	_KB_QRYEXPR_H

#include	"libkbase_exports.h"

/*  KBQryExpr								*/
/*  ---------								*/
/*  This class is used inside query definitions to define additional	*/
/*  expressions for filtering, ordering and grouping, as well as to	*/
/*  provide additional expressions which can be referenced when the	*/
/*  query it used.							*/

class LIBKBASE_API	KBQryExpr : public KBNode
{
public	:

	enum	Usage
	{
		AsExprOnly	= 0,
		AsSortAsc	= 1,
		AsSortDesc	= 2,
		AsWhere		= 3,
		AsGroup		= 4,
		AsHaving	= 5
	}	;

private	:

	KBAttrStr	expr	;	/* SQL Expression text		*/
	KBAttrStr	alias	;	/* As alias			*/
	KBAttrUInt	usage	;	/* What used for		*/

public	:

	KBQryExpr (KBNode *, const QDict<QString> &, bool * = 0) ;
	KBQryExpr (KBNode *, const QString &, const QString &, Usage) ;
	KBQryExpr (KBNode *, KBQryExpr *) ;
virtual~KBQryExpr () ;

	virtual	KBQryExpr	*isQryExpr	() { return this ; }

	inline	QString	getExpr   () { return expr 	  .getValue   () ; }
	inline	QString	getAlias  () { return alias 	  .getValue   () ; }
	inline	Usage	getUsage  () { return (Usage)usage.getIntValue() ; }

	inline	void	setExpr   (const QString &_expr ) { expr .setValue(_expr ) ; }
	inline	void	setAlias  (const QString &_alias) { alias.setValue(_alias) ; }
	inline	void	setUsage  (Usage	  _usage) { usage.setValue(_usage) ; }

	QString		getSQL	  () ;
}	;

#endif	// _KB_QRYEXPR_H
