/***************************************************************************
    file	         : kb_qrynull.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_block.h"

#include	"kb_qrynull.h"
#include	"kb_item.h"
#include	"kb_nodereg.h"


KBQryNull::KBQryNull
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBQryBase (parent, aList, "KBQryNull")
{
}

KBQryNull::KBQryNull
	(	KBNode		*_parent,
		KBQryNull	*_query
	)
	:
	KBQryBase (_parent, _query)
{
}

KBQryNull::KBQryNull
	(	KBNode		*parent
	)
	:
	KBQryBase (parent, "KBQryNull")
{
}

KBQryNull::~KBQryNull ()
{
}

/*  KBQryNull								*/
/*  addItem	: Add a child form item					*/
/*  qlvl	: uint		: Query level				*/
/*  item	: KBItem *	: Child item				*/
/*  (returns)	: bool		: Item fetches from database		*/

bool	KBQryNull::addItem
	(	uint	,
		KBItem	*item
	)
{
	if (item == 0)
	{	m_items.clear () ;
		return	false	 ;
	}

	m_items.append	(item)	 ;
	return	true	;
}

/*  KBQryNull								*/
/*  remItem	: Remove a child form item				*/
/*  qlvl	: uint		: Query level				*/
/*  item	: KBItem *	: Child form item			*/
/*  (returns)	: void		:					*/

void	KBQryNull::remItem
	(	uint	,
		KBItem	*item
	)
{
	m_items.remove (item) ;
}

/*  KBQryNull								*/
/*  loadItems	: Load items from query					*/
/*  qlvl	: uint		: Caller's query level			*/
/*  qrow	: uint		: Caller's query row number		*/
/*  (returns)	: bool		: Success				*/

bool	KBQryNull::loadItems
	(	uint	,
		uint	
	)
{
	fprintf
	(	stderr,
		"KBQryNull::loadItems: setting field types\n"
	)	;

	LITER
	(	KBItem,
		m_items,
		item,

		item->setFieldType (&_kbString)
	)

	return	true	;
}

/*  KBQryNull								*/
/*  clearItems	: Clear items in the query				*/
/*  qlvl	: uint		: Caller's query level			*/
/*  qrow	: uint		: Caller's query row number		*/
/*  (returns)	: bool		: Success				*/

bool	KBQryNull::clearItems
	(	uint	,
		uint	
	)
{
	fprintf
	(	stderr,
		"KBQryNull::clearItems: setting field types\n"
	)	;

	LITER
	(	KBItem,
		m_items,
		item,

		item->clearValue (0, true) ;
	)

	return	true	;
}

/*  KBQryNull								*/
/*  replicate	: Replicate this null query				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New null query node			*/

KBNode	*KBQryNull::replicate
	(	KBNode	*_parent
	)
{
	return	new KBQryNull (_parent, this) ;
}



NEWNODE(QryNull, (cchar *)0, KF_FORM|KF_REPORT)
