/***************************************************************************
    file	         : kb_qryquery.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_queryset.h"
#include	"kb_qrylevel.h"
#include	"kb_qryquery.h"
#include	"kb_query.h"
#include	"kb_table.h"
#include	"kb_qryexpr.h"
#include	"kb_docroot.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"

#if		! __KB_RUNTIME
#include	"kb_propdlg.h"
#include	"kb_qryquerydlg.h"
#endif

/*  KBQryQuery								*/
/*  KBQryQuery	: Constructor for form query node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*		: bool *	:					*/
/*  (returns)	: KBQryQuery	:					*/

KBQryQuery::KBQryQuery
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBQryData	(parent, aList,		"KBQryQuery"),
	m_qryName	(this,	 "query", 	aList),
	m_qryWhere	(this,	 "where", 	aList),
	m_qryOrder	(this,	 "order", 	aList),
	m_qryGroup	(this,	 "group", 	aList),
	m_qryHaving	(this,	 "having", 	aList),
	m_topTable	(this,	 "toptable",	aList),
	m_limit		(this,	 "limit",	aList)
{
	m_qryRoot	= 0	;
}

/*  KBQryQuery								*/
/*  KBQryQuery	: Constructor for form query node			*/
/*  parent	: KBForm *	: Parent node				*/
/*  (returns)	: KBQryQuery	:					*/

KBQryQuery::KBQryQuery
	(	KBNode	*parent
	)
	:
	KBQryData	(parent, "KBQryQuery"	  ),
	m_qryName	(this,	 "query",  	""),
	m_qryWhere	(this,	 "where",  	""),
	m_qryOrder	(this,	 "order",  	""),
	m_qryGroup	(this,	 "group",  	""),
	m_qryHaving	(this,	 "having",  	""),
	m_topTable	(this,	 "toptable",	""),
	m_limit		(this,	 "limit",	(uint)0)
{
	m_qryRoot	= 0	;
}

/*  KBQryQuery								*/
/*  KBQryQuery	: Constructor for form query node			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _query	: KBQryQuery *	: Extant form query			*/
/*  (returns)	: KBQryQuery	:					*/

KBQryQuery::KBQryQuery
	(	KBNode		*_parent,
		KBQryQuery	*_query
	)
	:
	KBQryData	(_parent, _query),
	m_qryName	(this,	 "query",  	_query),
	m_qryWhere	(this,	 "where",  	_query),
	m_qryOrder	(this,	 "order",  	_query),
	m_qryGroup	(this,	 "group",  	_query),
	m_qryHaving	(this,	 "having",  	_query),
	m_topTable	(this,	 "toptable",	_query),
	m_limit		(this,	 "limit",	_query)
{
	m_qryRoot	= 0	;
}

/*  KBQryQuery								*/
/*  ~KBQryQuery	: Destructor for form query node			*/
/*  (returns)	:		:					*/

KBQryQuery::~KBQryQuery ()
{
	DELOBJ	(m_qryRoot) ;
}

/*  KBQryQuery								*/
/*  replicate	: Replicate this table query				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New table query node			*/

KBNode	*KBQryQuery::replicate
	(	KBNode	*_parent
	)
{
	return	new KBQryQuery (_parent, this) ;
}

/*  KBQryQuery								*/
/*  loadQueryDef: Load the query definition				*/
/*  location	: KBLocation &	: Query location			*/
/*  (returns)	: bool		: Success				*/

bool	KBQryQuery::loadQueryDef
	(	KBLocation	&location
	)
{
	KBError		 error	 ;
	QByteArray	 doc	 ;
	QList<KBTable>	 qryList ;

	DELOBJ	(m_qryRoot)	 ;

	/* Read in the query definition, and parse it. If either fails	*/
	/* then return an error, but also fabricate a dummy quert.	*/
	if (!location.contents (doc, error))
	{
		m_qryRoot  = new KBQuery () ;
		setError  (error) ;
		return	  false	  ;
	}
	if ((m_qryRoot = KBOpenQueryText (location, doc, error)) == 0)
	{
		setError  (error) ;
		m_qryRoot = new KBQuery () ;
		return	  false	  ;
	}

	/* Query loaded and parsed OK, so construct a set of query	*/
	/* levels corresponding to the top-level tables in the query.	*/
	/* Note that we process in reverse order so that they can be	*/
	/* chained top-to-bottom.					*/
	tabList   .clear () ;
	m_exprList.clear () ;

	m_qryRoot->getQueryInfo (svrName, qryList, m_exprList) ;
	if (!KBTable::blockUp (qryList, m_topTable.getValue(), tabList, error))
	{	setError (error) ;
		return	 false	 ;
	}

	return	true	;
}

/*  KBQryQuery								*/
/*  loadQueryDef: Load the query definition				*/
/*  (returns)	: bool		: Success				*/

bool	KBQryQuery::loadQueryDef ()
{
	KBLocation location
	(	getDocRoot()->getDBInfo(),
		"query",
		getDocRoot()->getLocation().docLocn,
		m_qryName.getValue ()
	)	;

	return	loadQueryDef (location) ;
}

/*  KBQryQuery								*/
/*  loadQuery	: Load query						*/
/*  (returns)	: bool		: Success				*/

bool	KBQryQuery::loadQuery ()
{
	if (m_qryRoot == 0)
		if (!loadQueryDef ()) return false ;

	KBQryLevel *next = 0 ;

	for (int idx = tabList.count() - 1 ; idx >= 0 ; idx -= 1)
	{
		next	= new KBQryLevel
			  (	getParent(),
				next,
				dbLink,
				idx,
				tabList.at(idx)
			  )	;
		qryLevels.insert (0, next) ;
	}

	/* Assemble the global where and order components. These are	*/
	/* based on our properties, plus expressions from the		*/
	/* underlying query.						*/
	QString	gWhere	= m_qryWhere .getValue() ;
	QString	gOrder	= m_qryOrder .getValue() ;
	QString	gGroup	= m_qryGroup .getValue() ;
	QString	gHaving	= m_qryHaving.getValue() ;
	QString	sWhere	= gWhere.isEmpty() ? "" : " and " ;
	QString	sOrder	= gOrder.isEmpty() ? "" : ", "	  ;
	QString	sGroup	= gGroup.isEmpty() ? "" : ", "	  ;

	LITER
	(
		KBQryExpr,
		m_exprList,
		expr,

		switch (expr->getUsage())
		{
			case KBQryExpr::AsSortAsc  :
				gOrder	+= sOrder  ;
				gOrder	+= expr->getExpr() ;
				sOrder	 = ", "	   ;
				break	 ;

			case KBQryExpr::AsSortDesc :
				gOrder	+= sOrder  ;
				gOrder	+= expr->getExpr() ;
				gOrder	+= " desc" ;
				sOrder	 = ", "	   ;
				break	 ;

			case KBQryExpr::AsWhere    :
				gWhere	+= sWhere  ;
				gWhere	+= expr->getExpr() ;
				sWhere	 = " and " ;
				break	 ;

			case KBQryExpr::AsGroup	   :
				gGroup	+= sGroup  ;
				gGroup	+= expr->getExpr() ;
				sGroup	 = ", "    ;
				break	 ;

			case KBQryExpr::AsHaving   :
				if (!gHaving.isEmpty())
				{
					setError
					(	KBError::Error,
						TR("Cannot have multiple \"having\" terms"),
						QString::null,
						__ERRLOCN
					)	;
					return	false	  ;
				}

				gHaving = expr->getExpr() ;
				break	;

			default	:
				break	;
		}
	)

	if (gGroup.isEmpty() && !gHaving.isEmpty())
	{
		setError
		(	KBError::Error,
			TR("Cannot have \"having\" without \"group by\""),
			"having " + gHaving,
			__ERRLOCN
		)	;
		return	false	;
	}

	qryLevels.at(0)->setGlobalWhere  (gWhere ) ;
	qryLevels.at(0)->setGlobalOrder  (gOrder ) ;
	qryLevels.at(0)->setGlobalGroup  (gGroup ) ;
	qryLevels.at(0)->setGlobalHaving (gHaving) ;
	qryLevels.at(0)->setLimit	 (m_limit.getIntValue()) ;

	return	linkServer (svrName) ;
}


/*  KBQryQuery								*/
/*  getFieldList: Get list of fields from database			*/
/*  qlvl	: uint		: Query level				*/
/*  fldList	: QList<KBFieldSpec>&					*/
/*				: Field list result			*/
/*  pKey	: int &		: Primary key index			*/
/*  (returns)	: bool		: Success				*/

bool	KBQryQuery::getFieldList
	(	uint			qlvl,
		QList<KBFieldSpec>	&fldList,
		int			&pKey
	)
{
	if (m_qryRoot == 0)
		if (!loadQueryDef ()) return false ;

	LITER
	(
		KBQryExpr,
		m_exprList,
		expr,

		if ( (expr->getUsage() == KBQryExpr::AsExprOnly) &&
		     (expr->getExpr () != "*") )
			fldList.append
			(	new KBFieldSpec
				(	0xffff0000,
					expr->getSQL(),
					"",
					KB::ITUnknown,
					0,
					0,
					0
				)
			)	;
	)

	return	KBQryData::getFieldList (qlvl, fldList, pKey) ;
}

/*  KBQryQuery								*/
/*  getLinkage	: Get parent/child table linkage			*/
/*  qlvl	: uint		: Child table level			*/
/*  mexp	: QString &	: Expression in parent			*/
/*  cexpr	: QString &	: Expression (table column) in child	*/
/*  (returns)	: bool		: Success				*/

bool	KBQryQuery::getLinkage
	(	uint		qlvl,
		QString		&mexpr,
		QString		&cexpr
	)
{
	if (!getQryLevel (qlvl))
		return false ;

	if ((qlvl < 1) || (qlvl >= tabList.count()))
	{
		KBError::EError
		(	"Invalid query level when fetching child expression",
			QString(TR("Level %1, %2 exist")).arg(qlvl).arg(tabList.count()),
			__ERRLOCN
		)	;
		return	false	;
	}

	KBTable	*tParent = tabList.at(qlvl - 1) ;
	KBTable	*tChild	 = tabList.at(qlvl    ) ;

	mexpr	= QString("%1.%2").arg(tParent->getName()).arg(tParent->getField ()) ;
	cexpr	= QString("%1.%2").arg(tChild ->getName()).arg(tParent->getField2()) ;

	fprintf	(stderr, "Linkage: %d: %s:%s\n", qlvl, (cchar *)mexpr, (cchar *)cexpr)  ;
	return	true	;
}

/*  KBQryQuery								*/
/*  getComment	: Get brief descriptive comment				*/
/*  qryLvl	: uint		: Query level				*/
/*  (returns)	: QString	: Comment				*/

QString	KBQryQuery::getComment
	(	uint		qryLvl
	)
{
	return	QString("Query: %1:%2").arg(m_qryName.getValue()).arg(qryLvl) ;
}

#if	! __KB_RUNTIME
/*  KBQryQuery								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBQryQuery::propertyDlg ()
{

	if (!qryQueryPropDlg (this, "Query", attribs)) return false ;

	qryLevels.clear () ;
	dropServer 	() ;

	return true   ;
}
#endif


NEWNODE(QryQuery, (cchar *)0, KF_FORM|KF_REPORT)
