/***************************************************************************
    file	         : kb_qrysql.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_item.h"
#include	"kb_database.h"
#include	"kb_queryset.h"
#include	"kb_qrylevel.h"
#include	"kb_qrysql.h"
#include	"kb_table.h"
#include	"kb_nodereg.h"



/*  KBQrySQL								*/
/*  KBQrySQL	: Constructor for free-text SQL query node		*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*		: bool *	:					*/
/*  (returns)	: KBQrySQL	:					*/

KBQrySQL::KBQrySQL
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBQryData	(parent, aList,	     "KBQrySQL"),
	m_server	(this,	 "server",   aList, KF_REQD),
	m_query		(this,   "query",    aList, KF_REQD),
	m_topTable	(this,   "toptable", aList)
{
	m_qryTabPtr	= 0 ;
}

/*  KBQrySQL								*/
/*  KBQrySQL	: Constructor for free-text SQL query node		*/
/*  parent	: KBForm *	: Parent node				*/
/*  (returns)	: KBQrySQL	:					*/

KBQrySQL::KBQrySQL
	(	KBNode	*parent
	)
	:
	KBQryData	(parent, "KBQrySQL"  ),
	m_server	(this,	 "server",   "", KF_REQD),
	m_query		(this,   "query",    "", KF_REQD),
	m_topTable	(this,   "toptable", "")
{
	m_qryTabPtr	= 0 ;
}

/*  KBQrySQL								*/
/*  KBQrySQL	: Constructor for free-text SQL query node		*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _query	: KBQrySQL *	: Extant form query			*/
/*  (returns)	: KBQrySQL	:					*/

KBQrySQL::KBQrySQL
	(	KBNode		*_parent,
		KBQrySQL	*_query
	)
	:
	KBQryData	(_parent, _query),
	m_server	(this,    "server",     _query, KF_REQD),
	m_query		(this,    "query",      _query, KF_REQD),
	m_topTable	(this,    "toptable",   _query)
{
	m_qryTabPtr	= 0 ;
}

/*  KBQrySQL								*/
/*  ~KBQrySQL	: Destructor for form query node			*/
/*  (returns)	:		:					*/

KBQrySQL::~KBQrySQL ()
{
	DELOBJ	(m_qryTabPtr) ;
}

/*  KBQrySQL								*/
/*  replicate	: Replicate this table query				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New table query node			*/

KBNode	*KBQrySQL::replicate
	(	KBNode	*_parent
	)
{
	return	new KBQrySQL (_parent, this) ;
}

/*  KBQrySQL								*/
/*  loadQuery	: Load query 						*/
/*  (returns)	: bool		: Success				*/

bool	KBQrySQL::loadQuery ()
{
	m_qryTabList.clear () ;
	qryLevels   .clear () ;
	DELOBJ	(m_qryTabPtr) ;

	if (!linkServer (m_server.getValue()))
		return	false	;

	if (!m_select.parseQuery
		(	m_query.getValue(),
			&dbLink
	   )	)
	{
		setError (m_select.lastError()) ;
		return	 false	;
	}

	KBQryLevel *qryLevel  = m_select.makeQryLevel
				(	this,
					dbLink,
					m_topTable.getValue(),
					m_qryTabPtr
				)	;

	qryLevels.append (qryLevel) ;

	return	true ;
}

/*  KBQrySQL								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBQrySQL::showAs
	(	KB::ShowAs	mode
	)
{
#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
	{	qryLevels.clear () ;
		DELOBJ (m_qryTabPtr) ;
	}
#endif
	KBNode::showAs (mode) ;
}

/*  KBQrySQL								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBQrySQL::printNode
	(	QString	&text,
		int	indent
	)
{
	QString		nodeText ;

	/* We override this method since we don't want to print a child	*/
	/* KBTable node, which does exist in the document.		*/
	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;

	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;

	if (!nodeText.isEmpty())
	{
		text	+= ">\n" ;
		text	+= nodeText ;
		text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
	}
	else	text	+= "/>\n" ;
}

/*  KBQrySQL								*/
/*  getComment	: Get brief descriptive comment				*/
/*  qryLvl	: uint		: Query level				*/
/*  (returns)	: QString	: Comment				*/

QString	KBQrySQL::getComment
	(	uint
	)
{
	return	m_select.getComment() ;
}

#if	! __KB_RUNTIME
/*  KBQrySQL								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBQrySQL::propertyDlg ()
{
	extern	bool	qrySQLPropDlg (KBQrySQL *, cchar *, QList<KBAttr> &) ;
	
	if (!qrySQLPropDlg (this, TR("SQL Query"), attribs)) return false ;

	qryLevels.clear  () ;
	dropServer 	 () ;

	return true   ;
}
#endif

NEWNODE(QrySQL, (cchar *)0, KF_FORM|KF_REPORT)
