/***************************************************************************
    file	         : kb_qtgraphic.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qimage.h>

#include	"kb_graphic.h"
#include	"kb_display.h"
#include	"kb_writer.h"
#include	"kb_ascii.h"


extern	const	QPixmap	&scalePixmap	(const QPixmap &, const QRect &, uint) ;


/*  KBCtrlGraphic							*/
/*  KBCtrlGraphic: Constructor for embeded graphic wrapper		*/
/*  display	 : KBDisplay *	: Parent display			*/
/*  graphic	 : KBGraphic 	: Parent graphic			*/
/*  (returns)	 : KBGraphic	:					*/

KBCtrlGraphic::KBCtrlGraphic
	(	KBDisplay	*display,
		KBGraphic	*graphic
	)
	:
	QLabel	  (display->getDisplayWidget()),
	KBControl (this, display, graphic),
	m_graphic (graphic)
{
}

/*  KBCtrlGraphic							*/
/*  ~KBCtrlGraphic: Destructor for embedded graphic			*/
/*  (returns)	 :		:					*/

KBCtrlGraphic::~KBCtrlGraphic ()
{
}

/*  KBCtrlGraphic							*/
/*  setValue	: Set graphic text					*/
/*  value	: const KBValue &: Image data				*/
/*  (returns)	: void		 :					*/

void	KBCtrlGraphic::setValue
	(	const KBValue	&value
	)
{
	QPixmap	pm ;

	pm.loadFromData
	(	(const unsigned char *)value.dataPtr(),
		value.dataLength()
	)	;

	setPixmap 
	(	scalePixmap
		(	pm,
			m_graphic->geometry(),
			m_graphic->autoSize()
	)	)	;
}

/*  KBCtrlGraphic							*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlGraphic::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		if (pixmap() != 0)
			new KBWriterPixmap
			(	writer,
				rect,
				scalePixmap (*pixmap(), rect, m_graphic->autoSize())
			)	;

		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}

