/***************************************************************************
    file	         : kb_qtmemo.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include 	"kb_qtmemo.moc"
#else
#include 	"kb_qtmemo.h"
#endif

#include	"kb_block.h"
#include	"kb_memo.h"
#include	"kb_display.h"
#include	"kb_writer.h"
#include	"kb_dialog.h"



/*  KBCtrlMemo								*/
/*  KBCtrlMemo	: Constructor for memo edit wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  memo	: KBMemo *	: Parent memo				*/
/*  drow	: uint		: Row number in memo			*/
/*  (returns)	: KBCtrlMemo	:					*/

KBCtrlMemo::KBCtrlMemo
	(	KBDisplay	*display,
		KBMemo		*memo,
		uint		drow
	)
	:
	TKTextEditor
	(	new TKTextDocument(manager = _KBDialog::getTextManager()),
		display->getDisplayWidget()
	),
	KBControl	(this, display, memo, drow),
	memo		(memo),
	mapper		(this)
{
	setHilite () ;

	connect	  (this, SIGNAL(changed(int)), SLOT(editChanged(int))) ;

	inSetValue= false ;
	modified  = false ;

	/* Install our own event filter on the text view, since this	*/
	/* is not the top-level (TKTextEditor) widger.			*/
	textView()->installEventFilter (this) ;
}

/*  KBCtrlMemo								*/
/*  ~KBCtrlMemo	: Desctructor for memo class				*/
/*  (returns)	:		:					*/

KBCtrlMemo::~KBCtrlMemo ()
{
}

/*  KBCtrlMemo								*/
/*  eventFilter	: Widget event filter					*/
/*  o		: QObject *	: Object originating event		*/
/*  e		: QEvent *	: Event in question			*/
/*  (returns)	: bool		: False to continue processing		*/

bool	KBCtrlMemo::eventFilter
	(	QObject	*o,
		QEvent	*e
	)
{
	if (e->type() == QEvent::KeyPress)
		return	false	;

	return	KBControl::eventFilter (o, e) ;
}

/*  KBCtrlMemo								*/
/*  viewSetFocusOK							*/
/*		: Check if OK to set focus into the memo		*/
/*  (returns)	: bool		: True if OK				*/

bool	KBCtrlMemo::viewSetFocusOK()
{
	return	memo->moveFocusOK (m_drow) ;
}

/*  KBCtrlMemo								*/
/*  setHilite	: Set highlight mode					*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::setHilite ()
{
	QString	hl = memo->getAttrVal("hilite") ;

	if (hl != curHilite)
	{
		setHighlight (hl) ;
		curHilite   = hl  ;
	}
}

/*  KBCtrlMemo								*/
/*  setPalette	: Set palette on widget					*/
/*  pal		: const QPalette *: Palette in question			*/
/*  (returns)	: void		  :					*/

void	KBCtrlMemo::setPalette
	(	const QPalette *pal
	)
{
	textView()->setPalette (*pal) ;
}

/*  KBCtrlMemo								*/
/*  setFont	: Set font on widget					*/
/*  font	: const QFont *	: Font in question			*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::setFont
	(	const QFont *font
	)
{
	manager->setFont (*font) ;
}

/*  KBCtrlMemo								*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
		setText (memo->getName()) ;
#endif
}

/*  KBCtrlMemo								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;
	redraw	() ;

#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (m_drow == 0))
	{
		showName    () ;
		textDocument()->setWrap(false) ;
		return	 ;
	}
#endif
	if (memo->isWrapping())
	{
		QString	wchars	= memo->getAttrVal("wrapchars") ;
		if (wchars.isEmpty()) wchars = " \t" ;

		textDocument()->setWrap     (true  ) ;
		textDocument()->setWrapMode (TKTextDocument::wrapWord) ;
		textDocument()->setWordBound(wchars) ;
	}
	else	textDocument()->setWrap     (false ) ;

	NOCHANGE
	(
		clear	() ;
	)
}

/*  KBCtrlMeno								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlMemo::giveFocus ()
{
	TKTextEditor::setFocus () ;
}


/*  KBCtrlMemo								*/
/*  setValue	: Set memo value					*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlMemo::setValue
	(	const KBValue	&value
	)
{
	NOCHANGE
	(
		setText (value.getRawText()) ;
		modified  = false  ;
	)

	KBControl::setValue (value) ;
}

/*  KBCtrlMemo								*/
/*  editChanged	: Something changes in the editor			*/
/*  id		: int		: What changes				*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::editChanged
	(	int		id
	)
{
	if ((id == Modification) && !inSetValue && (m_showing == KB::ShowAsData))
		if (startUpdate())
		{
			memo->userChange (memo->getBlock()->getCurDRow() + m_drow) ;
			modified = true ;
		}
}

/*  KBCtrlMemo								*/
/*  getValue	: Get memo value					*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBCtrlMemo::getValue ()
{
	QString	_text	= text () ;

	if (_text.isEmpty() && getIniValue().isNull())
		return	KBValue (memo->getFieldType()) ;

	return	KBValue (_text,  memo->getFieldType()) ;
}

/*  KBCtrlMemo								*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::clearValue
	(	bool	query
	)
{
	NOCHANGE
	(
		clear	()	;
	)

	KBControl::clearValue (query) ;
}

/*  KBCtrlMemo								*/
/*  changed	: Test if memo value has been changed			*/
/*  (returns)	: bool		: TRUE if changed			*/

bool	KBCtrlMemo::changed ()
{
	QString	val = text () ;
	QString	ini = getIniValue().getRawText() ;

	/* Special case: This handles the situation where the inital	*/
	/* value is null, otherwise we get empty != null.		*/
	if (val.isEmpty() && ini.isEmpty()) return false ;

	return	val != ini ;
}

/*  KBCtrlMemo								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlMemo::isEmpty ()
{
	return	text().isEmpty() ;
}

/*  KBCtrlMemo								*/
/*  isValid	: See if control is valid				*/
/*  allowNull	: bool		: True to ignore not-null check		*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlMemo::isValid
	(	bool		allowNull
	)
{
	QString	value	;

	if (!text().isEmpty() || !getIniValue().isNull())
		value	= text() ;
		
	if (!memo->checkValid (value, allowNull))
	{	setError (memo->lastError()) ;
		return	 false ;
	}

	return	true ;
}

/*  KBCtrlMemo								*/
/*  mainWidget	: Get the main widget for the control			*/
/*  (returns)	: QWidget *	: Widget in question			*/

QWidget	*KBCtrlMemo::mainWidget ()
{
	return	textView () ;
}

/*  KBCtrlMemo								*/
/*  write	: Write memo 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Memo area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlMemo::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		KBWriterText *w = new KBWriterText
				  (	writer,
					rect,
					memo->getPalette(true   ),
					memo->getFont   (true   ),
					value.getRawText(),
					0x1001,
					fSubs
				  )	;
		extra	= w->extra()	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}

/*  KBCtrlMemo								*/
/*  redraw	: Update to match design state				*/
/*  (returns)	: void		:					*/

void	KBCtrlMemo::redraw ()
{
	setHilite () ;
}
