/***************************************************************************
    file	         : kb_queryset.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QUERYSET_H
#define	_KB_QUERYSET_H

#include	<qlist.h>

#include	"libkbase_exports.h"

#ifdef _WIN32
#define uint UINT
#endif

class	KBRowSet	;
class	KBRowSetValue	;
class	KBQuerySet	;



/*  KBRowSet								*/
/*  --------								*/
/*  This class contains a set of values which comprise a row retrieved	*/
/*  from the database. It also contains flags used when updating the	*/
/*  associated database table.						*/

class	LIBKBASE_API	KBRowSet
{
	KB::RState	m_state	  ;	/* Row state			*/
	uint		m_size	  ;	/* Number of columns in row	*/
	KBRowSetValue	*m_values ;	/* Vector of column values	*/
	KBQuerySet	*m_subset ;	/* Query subset for this row	*/
	bool		m_marked  ;	/* Row is marked selected	*/
	bool		m_dirty	  ;	/* Row is dirty wrt. display	*/

	QString		*m_order  ;

public	:

	KBRowSet (uint) ;
       ~KBRowSet ()	;

	friend	class	KBQuerySet		;
	friend	class	KBQuerySetSortList	;
}	;


class	LIBKBASE_API	KBQuerySetSortList : public QList<KBRowSet>
{
	uint		m_sortCol	;
	bool		m_sortAsc	;
	KBItem		*m_sortItem	;
	KB::IType	m_sortType	;  

protected :

	virtual	int	compareItems (QCollection::Item, QCollection::Item) ;

	friend	class	KBQuerySet	;
}	;


/*  KBQuerySet								*/
/*  ----------								*/
/*  This class encapsulates sets of rows retured by SELECT queries. It	*/
/*  is typically updated after the successful execution of INSERT,	*/
/*  UPDATE and DELETE database queries.					*/

class	LIBKBASE_API	KBQuerySet
{
	KBQuerySetSortList	m_rowSets	;
	uint			m_nFields	;
	uint			m_totalRows	;
	int			m_lastMarked	;
	KBValue			m_empty		;
	uint			*m_widths	;
	KBValue::VTrans		*m_vtrans	;

	void	checkUpdate	(KBQryLevel *, uint, uint) ;
	void	clearAllMarked	()		;

public	:

		

	KBQuerySet	(uint)	;
       ~KBQuerySet	()	;

	inline	uint	getNumRows   ()	{ return m_rowSets.count () ; }
	inline	uint	getNumFields ()	{ return m_nFields 	    ; }
	inline	uint	getTotalRows () { return m_totalRows	    ; }

	inline	void	setTotalRows
			(	uint	t
			)
		{
			m_totalRows = t ;
		}

	/* Clear all current contents from the query set.		*/
	void		clear	     	()		;

	/* Delete and insert rows into the query set. Note that this	*/
	/* does not affect any tables (nor effect any changes) (and it	*/
	/* certainly doesn't _impact_ anything).			*/
	void		deleteRow    	(uint)		;
	void		insertRow    	(uint)		;

	/* Rows are marked dirty to indicate that the display may be	*/
	/* out of step ....						*/
	bool		rowIsDirty   	(uint, bool)	;
	void		markAllDirty 	()		;

	/* ... while rows are marked Inserted, etc., to reflect		*/
	/* differences with respect to an underlying table. They are	*/
	/* also marked is accordance with the user selecting rows.	*/
	void		setRowState  	(uint, KB::RState)	;
	KB::RState	getRowState  	(uint, KB::RState = KB::RSInSync) ;

	void		setRowMarked 	(uint, KB::MarkOp)	;
	bool		getRowMarked 	(uint)			;
	bool		deleteAllMarked	(uint &, KBNode *, KBError &) ;
	void		resetData	(uint)			;

	/* Setfield will extend the query set if necessary, but _only_	*/
	/* by adding a row immediately at the end of the query set.	*/
	/* Getting a non-existant value returns a null value.		*/
	bool		setField     	(uint, uint, const KBValue &, bool = false) ;
	const KBValue	&getField     	(uint, uint, bool &, bool = false) ;
	KBQuerySet      *getSubset    	(uint, uint) 		;

	uint		getWidth	(uint)			;
	void		setVTrans	(uint, KBValue::VTrans)	;
	KBValue::VTrans	getVTrans	(uint)			;

	void		sortByColumn 	(uint, bool,  KBItem *) ;
}	;

#endif	// _KB_QUERYSET_H
